/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.sparsematrix;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.sparsematrix.InstanceDataExporter;

public class InstanceDataExporterImpl
implements InstanceDataExporter {
    @Override
    public void outputInstanceData(InstanceData instanceData, String filename) throws IOException {
        this.outputInstanceData(instanceData, filename, "\t", "\n", "", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outputInstanceData(InstanceData instanceData, String filename, String fieldDelim, String recordDelim, String stringEscape, boolean includeHeader) throws IOException {
        try (BufferedWriter bw = null;){
            StringWriter w = new StringWriter();
            boolean includeLabel = false;
            boolean includeRun = false;
            boolean includeFold = false;
            boolean includeTrain = false;
            for (String label : instanceData.getLabelToInstanceMap().keySet()) {
                Iterator i$ = ((SortedMap)instanceData.getLabelToInstanceMap().get(label)).keySet().iterator();
                while (i$.hasNext()) {
                    int run = (Integer)i$.next();
                    Iterator i$2 = ((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).keySet().iterator();
                    while (i$2.hasNext()) {
                        int fold = (Integer)i$2.next();
                        Iterator i$3 = ((SortedMap)((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).get(fold)).keySet().iterator();
                        while (i$3.hasNext()) {
                            boolean train = (Boolean)i$3.next();
                            for (Map.Entry instanceClass : ((SortedMap)((SortedMap)((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).get(fold)).get(train)).entrySet()) {
                                w.write(Long.toString((Long)instanceClass.getKey()));
                                w.write(fieldDelim);
                                this.appendString((String)instanceClass.getValue(), stringEscape, w);
                                if (label.length() > 0) {
                                    includeLabel = true;
                                    w.write(fieldDelim);
                                    this.appendString(label, stringEscape, w);
                                }
                                if (run > 0) {
                                    includeRun = true;
                                    w.write(fieldDelim);
                                    w.write(Integer.toString(run));
                                }
                                if (fold > 0) {
                                    includeFold = true;
                                    w.write(fieldDelim);
                                    w.write(Integer.toString(fold));
                                }
                                if (((SortedMap)((SortedMap)((SortedMap)instanceData.getLabelToInstanceMap().get(label)).get(run)).get(fold)).size() > 1) {
                                    includeTrain = true;
                                    w.write(fieldDelim);
                                    w.write(train ? "1" : "0");
                                }
                                w.write(recordDelim);
                            }
                        }
                    }
                }
            }
            bw = new BufferedWriter(new FileWriter(filename));
            if (includeHeader) {
                this.appendString("instance_id", stringEscape, bw);
                bw.write(fieldDelim);
                this.appendString("class", stringEscape, bw);
                if (includeLabel) {
                    bw.write(fieldDelim);
                    this.appendString("label", stringEscape, bw);
                }
                if (includeRun) {
                    bw.write(fieldDelim);
                    this.appendString("run", stringEscape, bw);
                }
                if (includeFold) {
                    bw.write(fieldDelim);
                    this.appendString("fold", stringEscape, bw);
                }
                if (includeTrain) {
                    bw.write(fieldDelim);
                    this.appendString("train", stringEscape, bw);
                }
                bw.write(recordDelim);
            }
            bw.write(w.toString());
        }
    }

    private void appendString(String str, String stringEscape, Writer w) throws IOException {
        w.write(stringEscape);
        w.write(str);
        w.write(stringEscape);
    }
}

