/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.svmlight;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataFormatter;
import org.apache.ctakes.ytex.kernel.SparseDataFormatterFactory;
import org.apache.ctakes.ytex.libsvm.LibSVMFormatterFactory;

public class SVMLightFormatterFactory
implements SparseDataFormatterFactory {
    KernelUtil kernelUtil;

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    @Override
    public SparseDataFormatter getFormatter() {
        return new SVMLightFormatter(this.getKernelUtil());
    }

    public static class SVMLightFormatter
    extends LibSVMFormatterFactory.LibSVMFormatter {
        protected SortedMap<Boolean, SortedMap<Long, String>> foldInstanceLabelMap;

        public SVMLightFormatter(KernelUtil kernelUtil) {
            super(kernelUtil);
        }

        @Override
        public void exportFold(SparseData sparseData, SortedMap<Long, String> instanceClassMap, boolean train, String label, Integer run, Integer fold) throws IOException {
            String filename = FileUtil.getDataFilePrefix(this.outdir, label, run, fold, train) + "_data.txt";
            String idFilename = FileUtil.getDataFilePrefix(this.outdir, label, run, fold, train) + "_id.txt";
            if (train && this.foldInstanceLabelMap.size() == 2) {
                this.exportTransductiveData(filename, idFilename, sparseData, instanceClassMap, ((SortedMap)this.foldInstanceLabelMap.get(Boolean.FALSE)).keySet(), (BiMap<String, Integer>)((BiMap)this.labelToClassIndexMap.get(label)));
            } else {
                super.exportDataForLabel(filename, idFilename, sparseData, instanceClassMap, (BiMap<String, Integer>)((BiMap)this.labelToClassIndexMap.get(label)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<Long> exportTransductiveData(String filename, String idFilename, SparseData bagOfWordsData, SortedMap<Long, String> trainClassMap, Set<Long> testInstances, BiMap<String, Integer> classToIndexMap) throws IOException {
            ArrayList<Long> instanceIds = new ArrayList<Long>();
            BufferedWriter wData = null;
            BufferedWriter wId = null;
            try {
                wData = new BufferedWriter(new FileWriter(filename));
                wId = new BufferedWriter(new FileWriter(idFilename));
                instanceIds.addAll(this.exportDataForInstances(bagOfWordsData, trainClassMap, classToIndexMap, wData, wId));
                TreeMap<Long, String> testClassMap = new TreeMap<Long, String>();
                for (Long instanceId : testInstances) {
                    if (trainClassMap.containsKey(instanceId)) continue;
                    testClassMap.put(instanceId, "0");
                }
                instanceIds.addAll(this.exportDataForInstances(bagOfWordsData, testClassMap, classToIndexMap, wData, wId));
                ArrayList<Long> arrayList = instanceIds;
                return arrayList;
            }
            finally {
                if (wData != null) {
                    wData.close();
                }
                if (wId != null) {
                    wId.close();
                }
            }
        }

        @Override
        public void initializeExport(InstanceData instanceLabel, Properties properties, SparseData sparseData) throws IOException {
            this.exportProperties = properties;
            this.outdir = properties.getProperty("outdir");
            FileUtil.createOutdir(this.outdir);
            this.fillLabelToClassIndexMap(instanceLabel.getLabelToClassMap());
        }

        protected void fillLabelToClassIndexMap(Map<String, SortedSet<String>> labelToClassMap) {
            for (Map.Entry<String, SortedSet<String>> labelToClass : labelToClassMap.entrySet()) {
                HashBiMap classToIndexMap = HashBiMap.create();
                this.labelToClassIndexMap.put(labelToClass.getKey(), classToIndexMap);
                if (labelToClass.getValue().size() == 2) {
                    classToIndexMap.put((Object)labelToClass.getValue().first(), (Object)-1);
                    classToIndexMap.put((Object)labelToClass.getValue().last(), (Object)1);
                    continue;
                }
                int nIndex = 1;
                for (String className : labelToClass.getValue()) {
                    Integer classNumber = null;
                    try {
                        classNumber = Integer.parseInt(className);
                    }
                    catch (NumberFormatException fe) {
                        // empty catch block
                    }
                    if (classNumber == null) {
                        classToIndexMap.put((Object)className, (Object)nIndex++);
                        continue;
                    }
                    classToIndexMap.put((Object)className, (Object)classNumber);
                }
            }
            this.updateLabelClassMapTransductive();
        }

        @Override
        public void clearFold() {
            this.numericAttributeMap.clear();
            this.nominalAttributeMap.clear();
            this.foldInstanceLabelMap = null;
        }

        @Override
        public void initializeFold(SparseData sparseData, String label, Integer run, Integer fold, SortedMap<Boolean, SortedMap<Long, String>> foldInstanceLabelMap) throws IOException {
            super.initializeFold(sparseData, label, run, fold, foldInstanceLabelMap);
            this.foldInstanceLabelMap = foldInstanceLabelMap;
        }
    }
}

