/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.svmlight;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.ytex.kernel.ClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.model.ClassifierInstanceEvaluation;
import org.apache.ctakes.ytex.kernel.model.SVMClassifierEvaluation;
import org.apache.ctakes.ytex.libsvm.LibSVMParser;

public class SVMLightParser
extends LibSVMParser {
    static final Pattern psv = Pattern.compile("Number of SV:\\s(\\d+)\\s.*");
    static final Pattern pvc = Pattern.compile("Estimated VCdim of classifier: VCdim<=([\\d\\.]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parsePredictions(String predictionFile, String instanceFile, Properties props, String instanceIdFile, SVMClassifierEvaluation eval) throws IOException {
        List<Long> instanceIds = null;
        if (instanceIdFile != null) {
            instanceIds = this.parseInstanceIds(instanceIdFile);
        }
        boolean bStoreUnlabeled = "yes".equals(props.getProperty(ClassifierEvaluationParser.ParseOption.STORE_UNLABELED.getOptionKey(), ClassifierEvaluationParser.ParseOption.STORE_UNLABELED.getDefaultValue()));
        BufferedReader instanceReader = null;
        BufferedReader predictionReader = null;
        try {
            instanceReader = new BufferedReader(new FileReader(instanceFile));
            predictionReader = new BufferedReader(new FileReader(predictionFile));
            String instanceLine = null;
            String predictionLine = null;
            int nLine = 0;
            while ((instanceLine = instanceReader.readLine()) != null && (predictionLine = predictionReader.readLine()) != null) {
                long instanceId = instanceIds.size() > nLine ? instanceIds.get(nLine) : (long)nLine;
                ++nLine;
                int classIdTarget = Integer.parseInt(SVMLightParser.extractFirstToken(instanceLine, wsPattern));
                if (!bStoreUnlabeled && classIdTarget == 0) continue;
                ClassifierInstanceEvaluation result = new ClassifierInstanceEvaluation();
                result.setTargetClassId(classIdTarget == 0 ? null : Integer.valueOf(classIdTarget));
                int classIdPredicted = 0;
                try {
                    double dPredict = Double.parseDouble(predictionLine);
                    classIdPredicted = dPredict > 0.0 ? 1 : -1;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("error parsing:" + predictionLine);
                    nfe.printStackTrace(System.err);
                }
                result.setPredictedClassId(classIdPredicted);
                result.setInstanceId(instanceId);
                result.setClassifierEvaluation(eval);
                eval.getClassifierInstanceEvaluations().put(instanceId, result);
            }
        }
        finally {
            if (instanceReader != null) {
                try {
                    instanceReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            if (predictionReader != null) {
                try {
                    predictionReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTrainOutput(SVMClassifierEvaluation eval, String trainOutputFile) throws IOException {
        if (trainOutputFile == null) {
            return;
        }
        try (BufferedReader r = null;){
            r = new BufferedReader(new FileReader(trainOutputFile));
            String line = null;
            while ((line = r.readLine()) != null) {
                Matcher m = psv.matcher(line);
                if (m.matches()) {
                    eval.setSupportVectors(Integer.parseInt(m.group(1)));
                }
                if (!(m = pvc.matcher(line)).matches()) continue;
                eval.setVcdim(Double.parseDouble(m.group(1)));
            }
        }
    }

    @Override
    protected void parseResults(File dataDir, File outputDir, String model, String predict, SVMClassifierEvaluation eval, Properties props) throws IOException {
        super.parseResults(dataDir, outputDir, model, predict, eval, props);
        eval.setAlgorithm("svmlight");
        this.parseTrainOutput(eval, outputDir + File.separator + "output.txt");
    }

    @Override
    protected void storeResults(File dataDir, Properties props, SVMClassifierEvaluation eval) {
        this.storeSemiSupervised(props, eval, null);
    }
}

