/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.weka;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.ctakes.ytex.kernel.BagOfWordsDecorator;
import org.apache.ctakes.ytex.kernel.BagOfWordsExporter;
import org.apache.ctakes.ytex.kernel.dao.KernelEvaluationDao;
import org.apache.ctakes.ytex.kernel.model.KernelEvaluation;
import org.apache.ctakes.ytex.kernel.model.KernelEvaluationInstance;
import org.apache.ctakes.ytex.weka.GramMatrixExporter;
import org.apache.ctakes.ytex.weka.WekaBagOfWordsExporter;
import org.apache.ctakes.ytex.weka.WekaBagOfWordsExporterImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class GramMatrixExporterImpl
extends WekaBagOfWordsExporterImpl
implements GramMatrixExporter {
    private JdbcTemplate jdbcTemplate;
    private KernelEvaluationDao kernelEvaluationDao;
    private WekaBagOfWordsExporter bagOfWordsExporter;

    public KernelEvaluationDao getKernelEvaluationDao() {
        return this.kernelEvaluationDao;
    }

    public BagOfWordsExporter getBagOfWordsExporter() {
        return this.bagOfWordsExporter;
    }

    public void setBagOfWordsExporter(WekaBagOfWordsExporter bagOfWordsExporter) {
        this.bagOfWordsExporter = bagOfWordsExporter;
    }

    public void setKernelEvaluationDao(KernelEvaluationDao kernelEvaluationDao) {
        this.kernelEvaluationDao = kernelEvaluationDao;
    }

    @Override
    public void setDataSource(DataSource ds) {
        this.jdbcTemplate = new JdbcTemplate(ds);
    }

    @Override
    public DataSource getDataSource(DataSource ds) {
        return this.jdbcTemplate.getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportGramMatrix(String propertyFile) throws IOException {
        Properties props = new Properties();
        BufferedWriter matrixWriter = null;
        InputStream in = null;
        try {
            HashMap<Long, Integer> instanceIdToIndexMap = new HashMap<Long, Integer>();
            TreeMap<Long, String> instanceIDClassLabel = new TreeMap<Long, String>();
            in = new FileInputStream(propertyFile);
            if (propertyFile.endsWith(".xml")) {
                props.loadFromXML(in);
            } else {
                props.load(in);
            }
            matrixWriter = new BufferedWriter(new FileWriter(props.getProperty("matrixFile")));
            String kernelEvaluationNames = props.getProperty("kernelEvaluationNames");
            KernelEvaluation kernelEvaluation = null;
            HashSet setKernelEvaluationNames = new HashSet();
            Collections.addAll(setKernelEvaluationNames, kernelEvaluationNames.split(","));
            this.initializeInstanceIndices(props.getProperty("instanceClassQuery"), instanceIDClassLabel, instanceIdToIndexMap);
            this.bagOfWordsExporter.exportBagOfWords(propertyFile, new GramMatrixArffDecorator(instanceIdToIndexMap));
            this.exportGramMatrix(matrixWriter, kernelEvaluation, GramMatrixType.WEKA, instanceIDClassLabel, instanceIdToIndexMap);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
            try {
                if (matrixWriter != null) {
                    matrixWriter.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected Map<Long, Integer> exportGramMatrix(BufferedWriter writer, final KernelEvaluation kernelEvaluation, GramMatrixType matrixType, Map<Long, String> instanceIDClassLabel, final Map<Long, Integer> instanceToIndexMap) throws IOException {
        final double[][] gramMatrix = new double[instanceIDClassLabel.size()][instanceIDClassLabel.size()];
        for (Map.Entry<Long, Integer> instanceIdIndex : instanceToIndexMap.entrySet()) {
            final int indexThis = instanceIdIndex.getValue();
            final long instanceId = instanceIdIndex.getKey();
            this.txNew.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus arg0) {
                    for (KernelEvaluationInstance keval : GramMatrixExporterImpl.this.getKernelEvaluationDao().getAllKernelEvaluationsForInstance(kernelEvaluation, instanceId)) {
                        Integer indexOther = null;
                        indexOther = instanceId != keval.getInstanceId1() ? (Integer)instanceToIndexMap.get(keval.getInstanceId1()) : (instanceId != keval.getInstanceId2() ? (Integer)instanceToIndexMap.get(keval.getInstanceId2()) : Integer.valueOf(indexThis));
                        if (indexOther == null) continue;
                        gramMatrix[indexThis][indexOther.intValue()] = keval.getSimilarity();
                        gramMatrix[indexOther.intValue()][indexThis] = keval.getSimilarity();
                    }
                    return null;
                }
            });
        }
        for (int j = 0; j < gramMatrix.length; ++j) {
            if (gramMatrix[j][j] != 0.0) continue;
            gramMatrix[j][j] = 1.0;
        }
        if (matrixType == GramMatrixType.WEKA) {
            this.exportWekaGramMatrix(gramMatrix, writer);
        }
        return instanceToIndexMap;
    }

    private void initializeInstanceIndices(String instanceClassQuery, final Map<Long, String> instanceIDClassLabel, Map<Long, Integer> instanceToIndexMap) {
        this.jdbcTemplate.query(instanceClassQuery, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                instanceIDClassLabel.put(rs.getLong(1), rs.getString(2));
            }
        });
        int i = 0;
        for (Long instanceId : instanceIDClassLabel.keySet()) {
            instanceToIndexMap.put(instanceId, i);
            ++i;
        }
    }

    private void exportWekaGramMatrix(double[][] gramMatrix, BufferedWriter writer) throws IOException {
        writer.write(Integer.toString(gramMatrix.length));
        writer.write("\t");
        writer.write(Integer.toString(gramMatrix.length));
        writer.write("\t");
        writer.newLine();
        for (int nRow = 0; nRow < gramMatrix.length; ++nRow) {
            double[] row = gramMatrix[nRow];
            for (int nCol = 0; nCol < row.length; ++nCol) {
                writer.write(Double.toString(row[nCol]));
                writer.write("\t");
            }
            writer.newLine();
        }
    }

    public static class GramMatrixArffDecorator
    implements BagOfWordsDecorator {
        public static final String INDEX_NAME = "gramIndex";
        public static final String INDEX_NAME_NOMINAL = "gramIndexN";
        Map<Long, Integer> instanceIdToIndexMap;

        public GramMatrixArffDecorator(Map<Long, Integer> instanceIdToIndexMap) {
            this.instanceIdToIndexMap = instanceIdToIndexMap;
        }

        @Override
        public void decorateNumericInstanceWords(Map<Long, SortedMap<String, Double>> instanceNumericWords, SortedSet<String> numericWords) {
            for (Map.Entry<Long, Integer> instanceIdToIndex : this.instanceIdToIndexMap.entrySet()) {
                long instanceId = instanceIdToIndex.getKey();
                int index = instanceIdToIndex.getValue();
                if (!instanceNumericWords.containsKey(instanceId)) {
                    instanceNumericWords.put(instanceId, new TreeMap());
                }
                instanceNumericWords.get(instanceId).put(INDEX_NAME, Double.valueOf(index));
            }
            numericWords.add(INDEX_NAME);
        }

        @Override
        public void decorateNominalInstanceWords(Map<Long, SortedMap<String, String>> instanceNominalWords, Map<String, SortedSet<String>> nominalWordValueMap) {
        }
    }

    public static enum GramMatrixType {
        WEKA,
        LIBSVM;

    }
}

