/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.weka;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.weka.WekaResultsImporter;

public class ImportWekaResults {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void docPredImport(String predictions, String task) throws Exception {
        WekaResultsImporter importer = (WekaResultsImporter)KernelContextHolder.getApplicationContext().getBean("wekaResultsImporter");
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(predictions));
            importer.importDocumentResults(task, reader);
        }
    }

    private static Options initOptions() {
        Options options = new Options();
        OptionGroup og = new OptionGroup();
        OptionBuilder.withArgName((String)"cvDir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"fold cross-validation results directory");
        og.addOption(OptionBuilder.create((String)"cvDir"));
        OptionBuilder.withArgName((String)"document");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"document prediction output");
        og.addOption(OptionBuilder.create((String)"docPred"));
        OptionBuilder.withArgName((String)"document");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"prediction");
        og.addOption(OptionBuilder.create((String)"pred"));
        options.addOptionGroup(og);
        OptionBuilder.withArgName((String)"algo");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"algorithm");
        options.addOption(OptionBuilder.create((String)"algo"));
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"name");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"name"));
        OptionBuilder.withArgName((String)"experiment");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"experiment");
        options.addOption(OptionBuilder.create((String)"experiment"));
        OptionBuilder.withArgName((String)"label");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"label / task");
        options.addOption(OptionBuilder.create((String)"label"));
        OptionBuilder.withArgName((String)"yes/no");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"store probabilities, default yes");
        options.addOption(OptionBuilder.create((String)"storeProb"));
        return options;
    }

    public static void main(String[] args) throws Exception {
        Options options = ImportWekaResults.initOptions();
        if (args.length == 0) {
            ImportWekaResults.printHelp(options);
        } else {
            GnuParser oparser = new GnuParser();
            try {
                CommandLine line = oparser.parse(options, args);
                if (line.hasOption("cvDir")) {
                    ImportWekaResults.importDirectory(line);
                } else if (line.hasOption("docPred")) {
                    ImportWekaResults.docPredImport(options.getOption("docPred").getValue(), options.getOption("label").getValue());
                } else if (line.hasOption("pred")) {
                    ImportWekaResults.importPred(line);
                }
            }
            catch (ParseException e) {
                ImportWekaResults.printHelp(options);
                throw e;
            }
        }
    }

    private static void importPred(CommandLine line) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importDirectory(CommandLine line) throws Exception {
        WekaResultsImporter importer = (WekaResultsImporter)KernelContextHolder.getApplicationContext().getBean("wekaResultsImporter");
        File cvDir = new File(line.getOptionValue("cvDir"));
        if (cvDir.listFiles() == null || cvDir.listFiles().length == 0) {
            System.err.println("directory is empty: " + cvDir);
        } else {
            for (File resultDir : cvDir.listFiles()) {
                String model = resultDir + File.separator + "model.obj";
                String output = resultDir + File.separator + "predict.txt";
                String optionsFile = resultDir + File.separator + "options.properties";
                if (!ImportWekaResults.checkFileRead(output) || !ImportWekaResults.checkFileRead(optionsFile)) continue;
                String options = null;
                Integer fold = null;
                try (InputStream isOptions = null;){
                    isOptions = new FileInputStream(optionsFile);
                    Properties props = new Properties();
                    props.load(isOptions);
                    options = props.getProperty("options");
                    String strFold = props.getProperty("fold");
                    if (strFold != null) {
                        try {
                            fold = Integer.parseInt(strFold);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                    }
                }
                if (options == null) continue;
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(output));
                    importer.importClassifierEvaluation(line.getOptionValue("name"), fold, line.getOptionValue("algo", "weka"), line.getOptionValue("label"), options, line.getOptionValue("experiment"), r);
                }
                finally {
                    try {
                        r.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private static boolean checkFileRead(String file) {
        return new File(file).canRead();
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java org.apache.ctakes.ytex.weka.ImportWekaResults\n", options);
    }
}

