/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.weka;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.model.ClassifierEvaluation;
import org.apache.ctakes.ytex.kernel.model.ClassifierInstanceEvaluation;
import org.apache.ctakes.ytex.weka.DocumentResultInstanceImporter;
import org.apache.ctakes.ytex.weka.WekaResultInstanceImporter;
import org.apache.ctakes.ytex.weka.WekaResultsImporter;
import org.hibernate.SessionFactory;

public class WekaResultsImporterImpl
implements WekaResultsImporter {
    private static final Pattern patHeader = Pattern.compile("\\s*inst#.*actual.*predicted.*error");
    private static final Pattern patResult = Pattern.compile("\\s+(\\d+)\\s+(\\d+)\\:.*\\s+(\\d+)\\:.*\\s+\\+{0,1}\\s+(.*)\\s+\\((.*)\\)");
    private SessionFactory sessionFactory;
    private static final Log log = LogFactory.getLog(DocumentResultInstanceImporter.class);
    private DocumentResultInstanceImporter docResultInstanceImporter;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public DocumentResultInstanceImporter getDocResultInstanceImporter() {
        return this.docResultInstanceImporter;
    }

    public void setDocResultInstanceImporter(DocumentResultInstanceImporter docResultInstanceImporter) {
        this.docResultInstanceImporter = docResultInstanceImporter;
    }

    @Override
    public void importDocumentResults(String task, BufferedReader reader) throws IOException {
        this.importResults(this.docResultInstanceImporter, task, reader);
    }

    @Override
    public void importResults(WekaResultInstanceImporter resultInstanceImporter, String task, BufferedReader reader) throws IOException {
        String line = null;
        boolean keepGoing = true;
        boolean inResults = false;
        while ((line = reader.readLine()) != null && keepGoing) {
            if (!inResults) {
                inResults = patHeader.matcher(line).find();
                continue;
            }
            Matcher matcher = patResult.matcher(line);
            if (matcher.find()) {
                int instanceNum = Integer.parseInt(matcher.group(1));
                int classGold = Integer.parseInt(matcher.group(2));
                int classAuto = Integer.parseInt(matcher.group(3));
                String[] arrPredictionStr = matcher.group(4).split("\\*|,|\\s");
                ArrayList<Double> listPredictions = new ArrayList<Double>(arrPredictionStr.length);
                for (String predStr : arrPredictionStr) {
                    if (predStr.length() <= 0) continue;
                    listPredictions.add(new Double(predStr));
                }
                List<String> instanceKey = Arrays.asList(matcher.group(5).split(","));
                resultInstanceImporter.importInstanceResult(instanceNum, instanceKey, task, classAuto, classGold, listPredictions);
                continue;
            }
            keepGoing = false;
        }
    }

    @Override
    public void importClassifierEvaluation(String name, Integer fold, String algorithm, String label, String options, String experiment, BufferedReader reader) throws IOException {
        ClassifierEvaluation ce = new ClassifierEvaluation();
        ce.setName(name);
        ce.setFold(fold);
        ce.setAlgorithm(algorithm);
        ce.setLabel(label);
        ce.setOptions(options);
        ce.setExperiment(experiment);
        this.getSessionFactory().getCurrentSession().save((Object)ce);
        ClassifierEvaluationInstanceImporter instanceImporter = new ClassifierEvaluationInstanceImporter(ce, false);
        this.importResults(instanceImporter, label, reader);
    }

    public class ClassifierEvaluationInstanceImporter
    implements WekaResultInstanceImporter {
        private ClassifierEvaluation classifierEvaluation;
        private boolean storeProbabilities;

        public ClassifierEvaluationInstanceImporter(ClassifierEvaluation classifierEvaluation, boolean storeProbabilities) {
            this.classifierEvaluation = classifierEvaluation;
            this.storeProbabilities = storeProbabilities;
        }

        @Override
        public void importInstanceResult(Integer instanceNumber, List<String> instanceKey, String task, int classAuto, int classGold, List<Double> predictions) {
            ClassifierInstanceEvaluation ci = new ClassifierInstanceEvaluation();
            if (instanceKey.size() > 0) {
                try {
                    ci.setInstanceId(Integer.parseInt(instanceKey.get(0)));
                }
                catch (NumberFormatException nfe) {}
            } else {
                ci.setInstanceId(instanceNumber.intValue());
            }
            ci.setPredictedClassId(classAuto);
            ci.setTargetClassId(classGold);
            if (this.storeProbabilities && predictions != null && predictions.size() > 0) {
                for (int i = 0; i < predictions.size(); ++i) {
                    ci.getClassifierInstanceProbabilities().put(i, predictions.get(i));
                }
            }
            ci.setClassifierEvaluation(this.classifierEvaluation);
            WekaResultsImporterImpl.this.sessionFactory.getCurrentSession().save((Object)ci);
        }
    }
}

