/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.annotators;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.ytex.uima.ApplicationContextHolder;
import org.apache.ctakes.ytex.uima.dao.NamedEntityRegexDao;
import org.apache.ctakes.ytex.uima.model.NamedEntityRegex;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class NamedEntityRegexAnnotator
extends JCasAnnotator_ImplBase {
    private static final Log log = LogFactory.getLog(NamedEntityRegexAnnotator.class);
    private NamedEntityRegexDao neRegexDao;
    private Map<NamedEntityRegex, Pattern> regexMap = new HashMap<NamedEntityRegex, Pattern>();

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.neRegexDao = (NamedEntityRegexDao)ApplicationContextHolder.getApplicationContext().getBean("namedEntityRegexDao");
        List<NamedEntityRegex> regexList = this.neRegexDao.getNamedEntityRegexs();
        this.initRegexMap(regexList);
    }

    protected void initRegexMap(List<NamedEntityRegex> regexList) {
        for (NamedEntityRegex regex : regexList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)regex);
            }
            Pattern pat = Pattern.compile(regex.getRegex());
            this.regexMap.put(regex, pat);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        for (Map.Entry<NamedEntityRegex, Pattern> entry : this.regexMap.entrySet()) {
            if (entry.getKey().getContext() != null) {
                AnnotationIndex idx = aJCas.getAnnotationIndex(Segment.typeIndexID);
                for (Segment segment : idx) {
                    if (!entry.getKey().getContext().equals(segment.getId())) continue;
                    this.processRegex(aJCas, segment, entry.getKey(), entry.getValue());
                }
                continue;
            }
            this.processRegex(aJCas, null, entry.getKey(), entry.getValue());
        }
    }

    private void processRegex(JCas aJCas, Annotation anno, NamedEntityRegex neRegex, Pattern pattern) {
        String docText = aJCas.getDocumentText();
        String annoText = anno != null ? docText.substring(anno.getBegin(), anno.getEnd()) : docText;
        int nOffset = anno != null ? anno.getBegin() : 0;
        Matcher matcher = pattern.matcher(annoText);
        while (matcher.find()) {
            EntityMention ne = new EntityMention(aJCas);
            ne.setBegin(nOffset + matcher.start());
            ne.setEnd(nOffset + matcher.end());
            FSArray ocArr = new FSArray(aJCas, 1);
            OntologyConcept oc = new OntologyConcept(aJCas);
            oc.setCode(neRegex.getCode());
            oc.setCodingScheme(neRegex.getCodingScheme());
            oc.setOid(neRegex.getOid());
            ocArr.set(0, (FeatureStructure)oc);
            ne.setOntologyConceptArr(ocArr);
            ne.addToIndexes();
        }
    }
}

