/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.annotators;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.typesystem.type.textsem.ContextAnnotation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class NegexAnnotator
extends JCasAnnotator_ImplBase {
    private static final Log log = LogFactory.getLog(NegexAnnotator.class);
    private List<NegexRule> listNegexRules = null;
    private boolean negatePossibilities = true;
    private boolean checkPossibilities = true;
    private boolean storeAsInterval = false;
    private String targetTypeName = null;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.listNegexRules = this.initializeRules();
        this.negatePossibilities = this.getBooleanConfigParam(aContext, "negatePossibilities", this.negatePossibilities);
        this.checkPossibilities = this.negatePossibilities ? true : this.getBooleanConfigParam(aContext, "checkPossibilities", this.checkPossibilities);
        this.storeAsInterval = this.getBooleanConfigParam(aContext, "storeAsInterval", this.storeAsInterval);
        this.targetTypeName = (String)aContext.getConfigParameterValue("targetTypeName");
    }

    private boolean getBooleanConfigParam(UimaContext aContext, String param, boolean defaultVal) {
        Boolean paramValue = (Boolean)aContext.getConfigParameterValue(param);
        return paramValue == null ? defaultVal : paramValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> initalizeRuleList() {
        ArrayList<String> rules = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/ctakes/ytex/uima/annotators/negex_triggers.txt")));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    rules.add(line);
                }
            }
            catch (IOException e) {
                log.error((Object)"oops", (Throwable)e);
            }
            Collections.sort(rules, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int l2;
                    int l1 = o1.trim().length();
                    if (l1 < (l2 = o2.trim().length())) {
                        return 1;
                    }
                    if (l1 > l2) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"oops", (Throwable)e);
            }
        }
        return rules;
    }

    private List<NegexRule> initializeRules() {
        List<String> listRules = this.initalizeRuleList();
        ArrayList<NegexRule> listNegexRules = new ArrayList<NegexRule>(listRules.size());
        for (String rule : listRules) {
            Pattern p = Pattern.compile("[\\t]+");
            String[] ruleTokens = p.split(rule.trim());
            if (ruleTokens.length == 2) {
                String[] ruleMembers = ruleTokens[0].trim().split(" ");
                String rule2 = "";
                for (int i = 0; i <= ruleMembers.length - 1; ++i) {
                    if (ruleMembers[i].equals("")) continue;
                    rule2 = ruleMembers.length == 1 ? ruleMembers[i] : rule2 + ruleMembers[i].trim() + "\\s+";
                }
                if (rule2.endsWith("\\s+")) {
                    rule2 = rule2.substring(0, rule2.lastIndexOf("\\s+"));
                }
                String rule3 = "(?m)(?i)[[\\p{Punct}&&[^\\]\\[]]|\\s+](" + rule2 + ")[[\\p{Punct}&&[^_]]|\\s+]";
                Pattern p2 = Pattern.compile(rule3.trim());
                listNegexRules.add(new NegexRule(p2, rule2, ruleTokens[1].trim()));
                continue;
            }
            log.warn((Object)("could not parse rule:" + rule));
        }
        return listNegexRules;
    }

    public void process(JCas aJCas) {
        AnnotationIndex sentenceIdx = aJCas.getAnnotationIndex(Sentence.typeIndexID);
        AnnotationIndex neIdx = aJCas.getAnnotationIndex(IdentifiedAnnotation.typeIndexID);
        this.negateAnnotations(aJCas, sentenceIdx, neIdx, new NamedEntityTargetAnnoFilter());
        if (this.targetTypeName != null) {
            try {
                this.negateAnnotations(aJCas, sentenceIdx, aJCas.getAnnotationIndex(aJCas.getTypeSystem().getType(this.targetTypeName)), null);
            }
            catch (Exception e) {
                log.error((Object)("error getting typeSystemId for " + this.targetTypeName), (Throwable)e);
            }
        }
    }

    private void negateAnnotations(JCas aJCas, AnnotationIndex sentenceIdx, AnnotationIndex targetIdx, TargetAnnoFilter filter) {
        for (Sentence s : sentenceIdx) {
            FSIterator neIter = targetIdx.subiterator((AnnotationFS)s);
            while (neIter.hasNext()) {
                Annotation ne = (Annotation)neIter.next();
                if (filter != null && !filter.filter(ne)) continue;
                this.checkNegation(aJCas, s, ne);
            }
        }
    }

    private NegexToken findTokenByTag(String tag, String[] stopTags, boolean before, int neRelStart, int neRelEnd, NegexToken[] tokens) {
        HashSet<String> stopTagSet = new HashSet<String>(stopTags.length);
        stopTagSet.addAll(Arrays.asList(stopTags));
        if (before) {
            for (int i = neRelStart - 1; i > 0; --i) {
                if (tokens[i] == null) continue;
                if (tokens[i].getTag().equals(tag)) {
                    return tokens[i];
                }
                if (!stopTagSet.contains(tokens[i].getTag())) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = neRelEnd; i < tokens.length; ++i) {
                if (tokens[i] == null) continue;
                if (tokens[i].getTag().equals(tag)) {
                    return tokens[i];
                }
                if (!stopTagSet.contains(tokens[i].getTag())) {
                    continue;
                }
                break;
            }
        }
        return null;
    }

    private void checkNegation(JCas aJCas, Sentence s, Annotation ne) {
        if (this.storeAsInterval && ne instanceof IdentifiedAnnotation) {
            ((IdentifiedAnnotation)ne).setConfidence(1.0f);
        }
        String sentence = "." + s.getCoveredText() + ".";
        NegexToken[] tokens = new NegexToken[sentence.length()];
        CharBuffer buf = CharBuffer.wrap(sentence.toCharArray());
        int neRelStart = ne.getBegin() - s.getBegin() + 1;
        int neRelEnd = ne.getEnd() - s.getBegin() + 1;
        for (int i = neRelStart; i < neRelEnd; ++i) {
            buf.put(i, '_');
        }
        for (NegexRule rule : this.listNegexRules) {
            Matcher m = rule.getPattern().matcher(buf);
            while (m.find()) {
                boolean bUnoccupied = true;
                for (int i = m.start(); i < m.end() && bUnoccupied; ++i) {
                    bUnoccupied = tokens[i] == null;
                }
                if (!bUnoccupied) continue;
                NegexToken t = new NegexToken(m.start(), m.end(), rule);
                for (int i = m.start(); i < m.end() && bUnoccupied; ++i) {
                    buf.put(i, '_');
                    tokens[i] = t;
                }
            }
        }
        NegexToken t = this.findTokenByTag("[PREN]", new String[]{"[CONJ]", "[PSEU]", "[POST]", "[PREP]", "[POSP]"}, true, neRelStart, neRelEnd, tokens);
        if (t != null) {
            this.annotateNegation(aJCas, s, ne, t, true, false);
        } else {
            t = this.findTokenByTag("[POST]", new String[]{"[CONJ]", "[PSEU]", "[PREN]", "[PREP]", "[POSP]"}, false, neRelStart, neRelEnd, tokens);
            if (t != null) {
                this.annotateNegation(aJCas, s, ne, t, true, false);
            } else if (this.checkPossibilities || this.negatePossibilities) {
                t = this.findTokenByTag("[PREP]", new String[]{"[CONJ]", "[PSEU]", "[PREN]", "[POST]", "[POSP]"}, true, neRelStart, neRelEnd, tokens);
                if (t != null) {
                    this.annotateNegation(aJCas, s, ne, t, false, true);
                } else {
                    t = this.findTokenByTag("[POSP]", new String[]{"[CONJ]", "[PSEU]", "[PREN]", "[POST]", "[PREP]"}, false, neRelStart, neRelEnd, tokens);
                    if (t != null) {
                        this.annotateNegation(aJCas, s, ne, t, true, true);
                    }
                }
            }
        }
    }

    private void checkNegation2(JCas aJCas, Sentence s, IdentifiedAnnotation ne, boolean negPoss) {
        String sToReturn = "";
        String sScope = "";
        String filler = "_";
        String sentence = "." + s.getCoveredText() + ".";
        String phrase = ne.getCoveredText();
        Pattern pph = Pattern.compile(phrase.trim(), 2);
        Matcher mph = pph.matcher(sentence);
        CharBuffer buf = CharBuffer.wrap(sentence.toCharArray());
        while (mph.find()) {
            sentence = mph.replaceAll(" [PHRASE]" + mph.group().trim().replaceAll(" ", filler) + "[PHRASE]");
        }
        for (NegexRule rule : this.listNegexRules) {
            Matcher m = rule.getPattern().matcher(sentence);
            while (m.find()) {
                sentence = m.replaceAll(" " + rule.getTag() + m.group().trim().replaceAll(" ", filler) + rule.getTag() + " ");
            }
        }
        Pattern pSpace = Pattern.compile("[\\s+]");
        String[] sentenceTokens = pSpace.split(sentence);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sentenceTokens.length; ++i) {
            sb.append(" " + sentenceTokens[i].trim());
            if (!sentenceTokens[i].trim().startsWith("[PREN]")) continue;
            for (int j = i + 1; !(j >= sentenceTokens.length || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[POST]") || sentenceTokens[j].trim().startsWith("[PREP]") || sentenceTokens[j].trim().startsWith("[POSP]")); ++j) {
                if (!sentenceTokens[j].trim().startsWith("[PHRASE]")) continue;
                sentenceTokens[j] = sentenceTokens[j].trim().replaceAll("\\[PHRASE\\]", "[NEGATED]");
            }
        }
        sentence = sb.toString();
        pSpace = Pattern.compile("[\\s+]");
        sentenceTokens = pSpace.split(sentence);
        StringBuilder sb2 = new StringBuilder();
        for (int i = sentenceTokens.length - 1; i > 0; --i) {
            sb2.insert(0, sentenceTokens[i] + " ");
            if (!sentenceTokens[i].trim().startsWith("[POST]")) continue;
            for (int j = i - 1; !(j <= 0 || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[PREN]") || sentenceTokens[j].trim().startsWith("[PREP]") || sentenceTokens[j].trim().startsWith("[POSP]")); --j) {
                if (!sentenceTokens[j].trim().startsWith("[PHRASE]")) continue;
                sentenceTokens[j] = sentenceTokens[j].trim().replaceAll("\\[PHRASE\\]", "[NEGATED]");
            }
        }
        sentence = sb2.toString();
        if (negPoss) {
            pSpace = Pattern.compile("[\\s+]");
            sentenceTokens = pSpace.split(sentence);
            StringBuilder sb3 = new StringBuilder();
            for (int i = 0; i < sentenceTokens.length; ++i) {
                sb3.append(" " + sentenceTokens[i].trim());
                if (!sentenceTokens[i].trim().startsWith("[PREP]")) continue;
                for (int j = i + 1; !(j >= sentenceTokens.length || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[POST]") || sentenceTokens[j].trim().startsWith("[PREN]") || sentenceTokens[j].trim().startsWith("[POSP]")); ++j) {
                    if (!sentenceTokens[j].trim().startsWith("[PHRASE]")) continue;
                    sentenceTokens[j] = sentenceTokens[j].trim().replaceAll("\\[PHRASE\\]", "[POSSIBLE]");
                }
            }
            sentence = sb3.toString();
            pSpace = Pattern.compile("[\\s+]");
            sentenceTokens = pSpace.split(sentence);
            StringBuilder sb4 = new StringBuilder();
            for (int i = sentenceTokens.length - 1; i > 0; --i) {
                sb4.insert(0, sentenceTokens[i] + " ");
                if (!sentenceTokens[i].trim().startsWith("[POSP]")) continue;
                for (int j = i - 1; !(j <= 0 || sentenceTokens[j].trim().startsWith("[CONJ]") || sentenceTokens[j].trim().startsWith("[PSEU]") || sentenceTokens[j].trim().startsWith("[PREN]") || sentenceTokens[j].trim().startsWith("[PREP]") || sentenceTokens[j].trim().startsWith("[POST]")); --j) {
                    if (!sentenceTokens[j].trim().startsWith("[PHRASE]")) continue;
                    sentenceTokens[j] = sentenceTokens[j].trim().replaceAll("\\[PHRASE\\]", "[POSSIBLE]");
                }
            }
            sentence = sb4.toString();
        }
        sentence = sentence.replaceAll(filler, " ");
        sentence = sentence.substring(0, sentence.trim().lastIndexOf(46));
        if ((sentence = sentence.replaceFirst(".", "")).contains("[PREN]") || sentence.contains("[PREP]")) {
            int endOffset;
            int startOffset = sentence.indexOf("[PREN]");
            if (startOffset == -1) {
                startOffset = sentence.indexOf("[PREP]");
            }
            if ((endOffset = sentence.indexOf("[CONJ]")) == -1) {
                endOffset = sentence.indexOf("[PSEU]");
            }
            if (endOffset == -1) {
                endOffset = sentence.indexOf("[POST]");
            }
            if (endOffset == -1) {
                endOffset = sentence.indexOf("[POSP]");
            }
            if (endOffset == -1 || endOffset < startOffset) {
                endOffset = sentence.length() - 1;
            }
            sScope = sentence.substring(startOffset, endOffset + 1);
        }
        if (sentence.contains("[POST]") || sentence.contains("[POSP]")) {
            int startOffset;
            int endOffset = sentence.lastIndexOf("[POST]");
            if (endOffset == -1) {
                endOffset = sentence.lastIndexOf("[POSP]");
            }
            if ((startOffset = sentence.lastIndexOf("[CONJ]")) == -1) {
                startOffset = sentence.lastIndexOf("[PSEU]");
            }
            if (startOffset == -1) {
                startOffset = sentence.lastIndexOf("[PREN]");
            }
            if (startOffset == -1) {
                startOffset = sentence.lastIndexOf("[PREP]");
            }
            if (startOffset == -1) {
                startOffset = 0;
            }
            sScope = sentence.substring(startOffset, endOffset);
        }
        sentence = sentence.contains("[NEGATED]") ? sentence + "\t" + "negated" + "\t" + sScope : (sentence.contains("[POSSIBLE]") ? sentence + "\t" + "possible" + "\t" + sScope : sentence + "\t" + "affirmed" + "\t" + sScope);
        sToReturn = sentence;
        System.out.println(sToReturn);
    }

    private void annotateNegation(JCas aJCas, Sentence s, Annotation anno, NegexToken t, boolean negated, boolean possible) {
        if (anno instanceof IdentifiedAnnotation) {
            IdentifiedAnnotation ne = (IdentifiedAnnotation)anno;
            if (!this.storeAsInterval) {
                if (possible) {
                    ne.setConfidence(-1.0f);
                }
                if (negated || this.negatePossibilities && possible) {
                    ne.setPolarity(-1);
                }
            } else {
                float confidence;
                ne.setPolarity(negated || possible ? -1 : 0);
                float f = confidence = negated ? -1.0f : 1.0f;
                if (possible) {
                    confidence = (float)((double)confidence * 0.5);
                }
                ne.setConfidence(confidence);
            }
        } else {
            try {
                BeanUtils.setProperty((Object)anno, (String)"negated", (Object)negated);
                BeanUtils.setProperty((Object)anno, (String)"possible", (Object)possible);
            }
            catch (IllegalAccessException iae) {
                log.error((Object)"error negating annotation", (Throwable)iae);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"error negating annotation", (Throwable)e);
            }
        }
        ContextAnnotation nec = new ContextAnnotation(aJCas);
        nec.setBegin(s.getBegin() + t.getStart() - 1);
        nec.setEnd(s.getBegin() + t.getEnd() - 1);
        nec.setScope(t.getTag());
        nec.setFocusText(anno.getCoveredText());
        nec.addToIndexes();
    }

    public static class NegexToken
    implements Comparable<NegexToken> {
        private int start;
        private int end;
        private NegexRule rule;

        public String toString() {
            return "NegexToken [start=" + this.start + ", end=" + this.end + ", rule=" + this.rule + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
            result = 31 * result + this.start;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NegexToken other = (NegexToken)obj;
            if (this.end != other.end) {
                return false;
            }
            if (this.rule == null ? other.rule != null : !this.rule.equals(other.rule)) {
                return false;
            }
            return this.start == other.start;
        }

        public NegexToken(int start, int end, NegexRule rule) {
            this.start = start;
            this.end = end;
            this.rule = rule;
        }

        @Override
        public int compareTo(NegexToken o) {
            return new Integer(this.start).compareTo(o.start);
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public String getTag() {
            return this.rule.getTag();
        }
    }

    public static class NegexRule {
        private Pattern pattern;
        private String tag;
        private String rule;

        public String toString() {
            return "NegexRule [rule=" + this.rule + ", tag=" + this.tag + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NegexRule other = (NegexRule)obj;
            if (this.rule == null ? other.rule != null : !this.rule.equals(other.rule)) {
                return false;
            }
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        public NegexRule() {
        }

        public NegexRule(Pattern pattern, String rule, String tag) {
            this.pattern = pattern;
            this.tag = tag;
            this.rule = rule;
        }
    }

    public static class NamedEntityTargetAnnoFilter
    implements TargetAnnoFilter {
        @Override
        public boolean filter(Annotation anno) {
            if (!(anno instanceof IdentifiedAnnotation)) {
                return false;
            }
            IdentifiedAnnotation ia = (IdentifiedAnnotation)anno;
            return ia.getOntologyConceptArr() != null && ia.getOntologyConceptArr().size() > 0;
        }
    }

    public static interface TargetAnnoFilter {
        public boolean filter(Annotation var1);
    }
}

