/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZKPaths {
    public static String fixForNamespace(String namespace, String path) {
        if (namespace != null) {
            return ZKPaths.makePath(namespace, path);
        }
        return path;
    }

    public static String getNodeFromPath(String path) {
        PathUtils.validatePath(path);
        int i = path.lastIndexOf(47);
        if (i < 0) {
            return path;
        }
        if (i + 1 >= path.length()) {
            return "";
        }
        return path.substring(i + 1);
    }

    public static PathAndNode getPathAndNode(String path) {
        PathUtils.validatePath(path);
        int i = path.lastIndexOf(47);
        if (i < 0) {
            return new PathAndNode(path, "");
        }
        if (i + 1 >= path.length()) {
            return new PathAndNode("/", "");
        }
        String node = path.substring(i + 1);
        String parentPath = i > 0 ? path.substring(0, i) : "/";
        return new PathAndNode(parentPath, node);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zookeeper, path, true);
    }

    public static void mkdirs(ZooKeeper zookeeper, String path, boolean makeLastNode) throws InterruptedException, KeeperException {
        PathUtils.validatePath(path);
        int pos = 1;
        do {
            String subPath;
            if ((pos = path.indexOf(47, pos + 1)) == -1) {
                if (!makeLastNode) break;
                pos = path.length();
            }
            if (zookeeper.exists(subPath = path.substring(0, pos), false) != null) continue;
            try {
                zookeeper.create(subPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
                // empty catch block
            }
        } while (pos < path.length());
    }

    public static List<String> getSortedChildren(ZooKeeper zookeeper, String path) throws InterruptedException, KeeperException {
        List children = zookeeper.getChildren(path, false);
        ArrayList sortedList = Lists.newArrayList((Iterable)children);
        Collections.sort(sortedList);
        return sortedList;
    }

    public static String makePath(String parent, String child) {
        StringBuilder path = new StringBuilder();
        if (!parent.startsWith("/")) {
            path.append("/");
        }
        path.append(parent);
        if (child == null || child.length() == 0) {
            return path.toString();
        }
        if (!parent.endsWith("/")) {
            path.append("/");
        }
        if (child.startsWith("/")) {
            path.append(child.substring(1));
        } else {
            path.append(child);
        }
        return path.toString();
    }

    private ZKPaths() {
    }

    public static class PathAndNode {
        private final String path;
        private final String node;

        public PathAndNode(String path, String node) {
            this.path = path;
            this.node = node;
        }

        public String getPath() {
            return this.path;
        }

        public String getNode() {
            return this.node;
        }
    }
}

