/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.state;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionStateManager
implements Closeable {
    private static final int QUEUE_SIZE;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BlockingQueue<ConnectionState> eventQueue = new ArrayBlockingQueue<ConnectionState>(QUEUE_SIZE);
    private final CuratorFramework client;
    private final ListenerContainer<ConnectionStateListener> listeners = new ListenerContainer();
    private final AtomicReference<ConnectionState> currentState = new AtomicReference();
    private final ExecutorService service;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);

    public ConnectionStateManager(CuratorFramework client, ThreadFactory threadFactory) {
        this.client = client;
        if (threadFactory == null) {
            threadFactory = ThreadUtils.newThreadFactory((String)"ConnectionStateManager");
        }
        this.service = Executors.newSingleThreadExecutor(threadFactory);
    }

    public void start() {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Cannot be started more than once");
        this.service.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ConnectionStateManager.this.processEvents();
                return null;
            }
        });
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.service.shutdownNow();
            this.listeners.clear();
        }
    }

    public ListenerContainer<ConnectionStateListener> getListenable() {
        return this.listeners;
    }

    public void addStateChange(ConnectionState newState) {
        ConnectionState previousState;
        if (this.state.get() != State.STARTED) {
            return;
        }
        if (newState == ConnectionState.LOST) {
            this.client.getZookeeperClient().markLost();
        }
        if ((previousState = this.currentState.getAndSet(newState)) == newState) {
            return;
        }
        ConnectionState localState = previousState == null ? ConnectionState.CONNECTED : newState;
        this.log.info("State change: " + (Object)((Object)localState));
        while (!this.eventQueue.offer(localState)) {
            this.eventQueue.poll();
            this.log.warn("ConnectionStateManager queue full - dropping events to make room");
        }
    }

    private void processEvents() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                final ConnectionState newState = this.eventQueue.take();
                if (this.listeners.size() == 0) {
                    this.log.warn("There are no ConnectionStateListeners registered.");
                }
                this.listeners.forEach(new Function<ConnectionStateListener, Void>(){

                    public Void apply(ConnectionStateListener listener) {
                        listener.stateChanged(ConnectionStateManager.this.client, newState);
                        return null;
                    }
                });
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        int size = 25;
        String property = System.getProperty("ConnectionStateManagerSize", null);
        if (property != null) {
            try {
                size = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        QUEUE_SIZE = size;
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

