/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.common.PathUtils;

class NamespaceImpl {
    private final CuratorFrameworkImpl client;
    private final String namespace;
    private final EnsurePath ensurePath;

    NamespaceImpl(CuratorFrameworkImpl client, String namespace) {
        if (namespace != null) {
            try {
                PathUtils.validatePath((String)("/" + namespace));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid namespace: " + namespace);
            }
        }
        this.client = client;
        this.namespace = namespace;
        this.ensurePath = namespace != null ? new EnsurePath(ZKPaths.makePath((String)"/", (String)namespace)) : null;
    }

    String getNamespace() {
        return this.namespace;
    }

    String unfixForNamespace(String path) {
        String namespacePath;
        if (this.namespace != null && path != null && path.startsWith(namespacePath = ZKPaths.makePath((String)this.namespace, null))) {
            path = path.length() > namespacePath.length() ? path.substring(namespacePath.length()) : "/";
        }
        return path;
    }

    String fixForNamespace(String path) {
        if (this.ensurePath != null) {
            try {
                this.ensurePath.ensure(this.client.getZookeeperClient());
            }
            catch (Exception e) {
                this.client.logError("Ensure path threw exception", e);
            }
        }
        return ZKPaths.fixForNamespace((String)this.namespace, (String)path);
    }

    EnsurePath newNamespaceAwareEnsurePath(String path) {
        return new EnsurePath(this.fixForNamespace(path));
    }
}

