/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.Watching;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class GetChildrenBuilderImpl
implements GetChildrenBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private Watching watching;
    private Backgrounding backgrounding;
    private Stat responseStat;

    GetChildrenBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.watching = new Watching();
        this.backgrounding = new Backgrounding();
        this.responseStat = null;
    }

    @Override
    public WatchPathable<List<String>> storingStatIn(Stat stat) {
        this.responseStat = stat;
        return new WatchPathable<List<String>>(){

            @Override
            public List<String> forPath(String path) throws Exception {
                return GetChildrenBuilderImpl.this.forPath(path);
            }

            @Override
            public Pathable<List<String>> watched() {
                GetChildrenBuilderImpl.this.watched();
                return GetChildrenBuilderImpl.this;
            }

            @Override
            public Pathable<List<String>> usingWatcher(Watcher watcher) {
                GetChildrenBuilderImpl.this.usingWatcher(watcher);
                return GetChildrenBuilderImpl.this;
            }

            @Override
            public Pathable<List<String>> usingWatcher(CuratorWatcher watcher) {
                GetChildrenBuilderImpl.this.usingWatcher(watcher);
                return GetChildrenBuilderImpl.this;
            }
        };
    }

    @Override
    public Pathable<List<String>> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public Pathable<List<String>> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public Pathable<List<String>> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<List<String>> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<List<String>> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Pathable<List<String>> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public BackgroundPathable<List<String>> watched() {
        this.watching = new Watching(true);
        return this;
    }

    @Override
    public BackgroundPathable<List<String>> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public BackgroundPathable<List<String>> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("GetChildrenBuilderImpl-Background");
        AsyncCallback.Children2Callback callback = new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object o, List<String> strings, Stat stat) {
                trace.commit();
                if (strings == null) {
                    strings = Lists.newArrayList();
                }
                CuratorEventImpl event = new CuratorEventImpl(GetChildrenBuilderImpl.this.client, CuratorEventType.CHILDREN, rc, path, null, o, stat, null, strings, null, null);
                GetChildrenBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        };
        if (this.watching.isWatched()) {
            this.client.getZooKeeper().getChildren(operationAndData.getData(), true, callback, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().getChildren(operationAndData.getData(), this.watching.getWatcher(), callback, this.backgrounding.getContext());
        }
    }

    @Override
    public List<String> forPath(String path) throws Exception {
        path = this.client.fixForNamespace(path);
        List<String> children = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), null), null);
        } else {
            children = this.pathInForeground(path);
        }
        return children;
    }

    private List<String> pathInForeground(final String path) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("GetChildrenBuilderImpl-Foreground");
        List children = (List)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                List children = GetChildrenBuilderImpl.this.watching.isWatched() ? GetChildrenBuilderImpl.this.client.getZooKeeper().getChildren(path, true, GetChildrenBuilderImpl.this.responseStat) : GetChildrenBuilderImpl.this.client.getZooKeeper().getChildren(path, GetChildrenBuilderImpl.this.watching.getWatcher(), GetChildrenBuilderImpl.this.responseStat);
                return children;
            }
        });
        trace.commit();
        return children;
    }
}

