/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundEnsembleable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.api.Ensembleable;
import org.apache.curator.framework.api.GetConfigBuilder;
import org.apache.curator.framework.api.WatchBackgroundEnsembleable;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.Watching;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class GetConfigBuilderImpl
implements GetConfigBuilder,
BackgroundOperation<Void> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private Watching watching;
    private Stat stat;

    public GetConfigBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.watching = new Watching();
    }

    @Override
    public WatchBackgroundEnsembleable<byte[]> storingStatIn(Stat stat) {
        this.stat = stat;
        return new WatchBackgroundEnsembleable<byte[]>(){

            @Override
            public Ensembleable<byte[]> inBackground() {
                return GetConfigBuilderImpl.this.inBackground();
            }

            @Override
            public Ensembleable<byte[]> inBackground(Object context) {
                return GetConfigBuilderImpl.this.inBackground(context);
            }

            @Override
            public Ensembleable<byte[]> inBackground(BackgroundCallback callback) {
                return GetConfigBuilderImpl.this.inBackground(callback);
            }

            @Override
            public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Object context) {
                return GetConfigBuilderImpl.this.inBackground(callback, context);
            }

            @Override
            public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
                return GetConfigBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
                return GetConfigBuilderImpl.this.inBackground(callback, context, executor);
            }

            @Override
            public byte[] forEnsemble() throws Exception {
                return GetConfigBuilderImpl.this.forEnsemble();
            }

            @Override
            public BackgroundEnsembleable<byte[]> watched() {
                return GetConfigBuilderImpl.this.watched();
            }

            @Override
            public BackgroundEnsembleable<byte[]> usingWatcher(Watcher watcher) {
                return GetConfigBuilderImpl.this.usingWatcher(watcher);
            }

            @Override
            public BackgroundEnsembleable<byte[]> usingWatcher(CuratorWatcher watcher) {
                return GetConfigBuilderImpl.this.usingWatcher(watcher);
            }
        };
    }

    @Override
    public BackgroundEnsembleable<byte[]> watched() {
        this.watching = new Watching(true);
        return new InternalBackgroundEnsembleable();
    }

    @Override
    public BackgroundEnsembleable<byte[]> usingWatcher(Watcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return new InternalBackgroundEnsembleable();
    }

    @Override
    public BackgroundEnsembleable<byte[]> usingWatcher(CuratorWatcher watcher) {
        this.watching = new Watching(this.client, watcher);
        return new InternalBackgroundEnsembleable();
    }

    @Override
    public Ensembleable<byte[]> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public Ensembleable<byte[]> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Ensembleable<byte[]> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(callback, executor);
        return this;
    }

    @Override
    public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public byte[] forEnsemble() throws Exception {
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<Object>(this, null, this.backgrounding.getCallback(), null, this.backgrounding.getContext()), null);
            return null;
        }
        return this.configInForeground();
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<Void> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("GetDataBuilderImpl-Background");
        AsyncCallback.DataCallback callback = new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                trace.commit();
                CuratorEventImpl event = new CuratorEventImpl(GetConfigBuilderImpl.this.client, CuratorEventType.GET_CONFIG, rc, path, null, ctx, stat, data, null, null, null, null);
                GetConfigBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        };
        if (this.watching.isWatched()) {
            this.client.getZooKeeper().getConfig(true, callback, this.backgrounding.getContext());
        } else {
            this.client.getZooKeeper().getConfig(this.watching.getWatcher(this.client, "/zookeeper/config"), callback, this.backgrounding.getContext());
        }
    }

    private byte[] configInForeground() throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("GetConfigBuilderImpl-Foreground");
        try {
            byte[] byArray = (byte[])RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    if (GetConfigBuilderImpl.this.watching.isWatched()) {
                        return GetConfigBuilderImpl.this.client.getZooKeeper().getConfig(true, GetConfigBuilderImpl.this.stat);
                    }
                    return GetConfigBuilderImpl.this.client.getZooKeeper().getConfig(GetConfigBuilderImpl.this.watching.getWatcher(GetConfigBuilderImpl.this.client, "/zookeeper/config"), GetConfigBuilderImpl.this.stat);
                }
            });
            return byArray;
        }
        finally {
            trace.commit();
        }
    }

    private class InternalBackgroundEnsembleable
    implements BackgroundEnsembleable<byte[]> {
        private InternalBackgroundEnsembleable() {
        }

        @Override
        public Ensembleable<byte[]> inBackground() {
            return GetConfigBuilderImpl.this.inBackground();
        }

        @Override
        public Ensembleable<byte[]> inBackground(Object context) {
            return GetConfigBuilderImpl.this.inBackground(context);
        }

        @Override
        public Ensembleable<byte[]> inBackground(BackgroundCallback callback) {
            return GetConfigBuilderImpl.this.inBackground(callback);
        }

        @Override
        public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Object context) {
            return GetConfigBuilderImpl.this.inBackground(callback, context);
        }

        @Override
        public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Executor executor) {
            return GetConfigBuilderImpl.this.inBackground(callback, executor);
        }

        @Override
        public Ensembleable<byte[]> inBackground(BackgroundCallback callback, Object context, Executor executor) {
            return GetConfigBuilderImpl.this.inBackground(callback, context, executor);
        }

        @Override
        public byte[] forEnsemble() throws Exception {
            return GetConfigBuilderImpl.this.forEnsemble();
        }
    }
}

