/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.RemoveWatchesBuilderImpl;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherRemovalManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private final Set<WrappedWatcher> entries = Sets.newHashSet();

    WatcherRemovalManager(CuratorFrameworkImpl client) {
        this.client = client;
    }

    synchronized Watcher add(String path, Watcher watcher) {
        path = (String)Preconditions.checkNotNull((Object)path, (Object)"path cannot be null");
        watcher = (Watcher)Preconditions.checkNotNull((Object)watcher, (Object)"watcher cannot be null");
        WrappedWatcher wrappedWatcher = new WrappedWatcher(watcher, path);
        this.entries.add(wrappedWatcher);
        return wrappedWatcher;
    }

    @VisibleForTesting
    synchronized Set<? extends Watcher> getEntries() {
        return Sets.newHashSet(this.entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWatchers() {
        HashSet localEntries;
        WatcherRemovalManager watcherRemovalManager = this;
        synchronized (watcherRemovalManager) {
            localEntries = Sets.newHashSet(this.entries);
        }
        for (WrappedWatcher entry : localEntries) {
            try {
                this.log.debug("Removing watcher for path: " + entry.path);
                RemoveWatchesBuilderImpl builder = new RemoveWatchesBuilderImpl(this.client);
                builder.internalRemoval(entry, entry.path);
            }
            catch (Exception e) {
                this.log.error("Could not remove watcher for path: " + entry.path);
            }
        }
    }

    private synchronized void internalRemove(WrappedWatcher entry) {
        this.entries.remove(entry);
    }

    private class WrappedWatcher
    implements Watcher {
        private final Watcher watcher;
        private final String path;

        WrappedWatcher(Watcher watcher, String path) {
            this.watcher = watcher;
            this.path = path;
        }

        public void process(WatchedEvent event) {
            if (event.getType() != Watcher.Event.EventType.None) {
                WatcherRemovalManager.this.internalRemove(this);
            }
            this.watcher.process(event);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedWatcher entry = (WrappedWatcher)o;
            if (!this.watcher.equals(entry.watcher)) {
                return false;
            }
            return this.path.equals(entry.path);
        }

        public int hashCode() {
            int result = this.watcher.hashCode();
            result = 31 * result + this.path.hashCode();
            return result;
        }
    }
}

