/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.NamespaceWatcher;
import org.apache.zookeeper.Watcher;

class Watching {
    private final Watcher watcher;
    private final CuratorWatcher curatorWatcher;
    private final boolean watched;

    Watching(boolean watched) {
        this.watcher = null;
        this.curatorWatcher = null;
        this.watched = watched;
    }

    Watching(Watcher watcher) {
        this.watcher = watcher;
        this.curatorWatcher = null;
        this.watched = false;
    }

    Watching(CuratorWatcher watcher) {
        this.watcher = null;
        this.curatorWatcher = watcher;
        this.watched = false;
    }

    Watching() {
        this.watcher = null;
        this.watched = false;
        this.curatorWatcher = null;
    }

    Watcher getWatcher(CuratorFrameworkImpl client, String unfixedPath) {
        NamespaceWatcher namespaceWatcher = null;
        if (this.watcher != null) {
            namespaceWatcher = new NamespaceWatcher(client, this.watcher, unfixedPath);
        } else if (this.curatorWatcher != null) {
            namespaceWatcher = new NamespaceWatcher(client, this.curatorWatcher, unfixedPath);
        }
        if (namespaceWatcher != null && client.getWatcherRemovalManager() != null) {
            client.getWatcherRemovalManager().add(namespaceWatcher);
        }
        return namespaceWatcher;
    }

    boolean isWatched() {
        return this.watched;
    }
}

