/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.BackgroundVersionable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.DeleteBuilderMain;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.transaction.OperationType;
import org.apache.curator.framework.api.transaction.TransactionDeleteBuilder;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooKeeper;

class DeleteBuilderImpl
implements DeleteBuilder,
BackgroundOperation<String>,
ErrorListenerPathable<Void> {
    private final CuratorFrameworkImpl client;
    private int version;
    private Backgrounding backgrounding;
    private boolean deletingChildrenIfNeeded;
    private boolean guaranteed;
    private boolean quietly;

    DeleteBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.version = -1;
        this.backgrounding = new Backgrounding();
        this.deletingChildrenIfNeeded = false;
        this.guaranteed = false;
        this.quietly = false;
    }

    <T> TransactionDeleteBuilder<T> asTransactionDeleteBuilder(final T context, final CuratorMultiTransactionRecord transaction) {
        return new TransactionDeleteBuilder<T>(){

            @Override
            public T forPath(String path) throws Exception {
                String fixedPath = DeleteBuilderImpl.this.client.fixForNamespace(path);
                transaction.add(Op.delete((String)fixedPath, (int)DeleteBuilderImpl.this.version), OperationType.DELETE, path);
                return context;
            }

            @Override
            public Pathable<T> withVersion(int version) {
                DeleteBuilderImpl.this.withVersion(version);
                return this;
            }
        };
    }

    @Override
    public DeleteBuilderMain quietly() {
        this.quietly = true;
        return this;
    }

    @Override
    public ChildrenDeletable guaranteed() {
        this.guaranteed = true;
        return this;
    }

    @Override
    public BackgroundVersionable deletingChildrenIfNeeded() {
        this.deletingChildrenIfNeeded = true;
        return this;
    }

    @Override
    public BackgroundPathable<Void> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Void> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final TimeTrace trace = this.client.getZookeeperClient().startTracer("DeleteBuilderImpl-Background");
            this.client.getZooKeeper().delete(operationAndData.getData(), this.version, new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                    trace.commit();
                    if (rc == KeeperException.Code.NOTEMPTY.intValue() && DeleteBuilderImpl.this.deletingChildrenIfNeeded) {
                        DeleteBuilderImpl.this.backgroundDeleteChildrenThenNode(operationAndData);
                    } else {
                        if (rc == KeeperException.Code.NONODE.intValue() && DeleteBuilderImpl.this.quietly) {
                            rc = KeeperException.Code.OK.intValue();
                        }
                        CuratorEventImpl event = new CuratorEventImpl(DeleteBuilderImpl.this.client, CuratorEventType.DELETE, rc, path, null, ctx, null, null, null, null, null, null);
                        DeleteBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                    }
                }
            }, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    private void backgroundDeleteChildrenThenNode(final OperationAndData<String> mainOperationAndData) {
        BackgroundOperation<String> operation = new BackgroundOperation<String>(){

            @Override
            public void performBackgroundOperation(OperationAndData<String> dummy) throws Exception {
                try {
                    ZKPaths.deleteChildren((ZooKeeper)DeleteBuilderImpl.this.client.getZooKeeper(), (String)((String)mainOperationAndData.getData()), (boolean)false);
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
                DeleteBuilderImpl.this.client.queueOperation(mainOperationAndData);
            }
        };
        OperationAndData<String> parentOperation = new OperationAndData<String>(operation, mainOperationAndData.getData(), null, null, this.backgrounding.getContext(), null);
        this.client.queueOperation(parentOperation);
    }

    @Override
    public Void forPath(String path) throws Exception {
        this.client.getSchemaSet().getSchema(path).validateDelete();
        final String unfixedPath = path;
        path = this.client.fixForNamespace(path);
        if (this.backgrounding.inBackground()) {
            OperationAndData.ErrorCallback<String> errorCallback = null;
            if (this.guaranteed) {
                errorCallback = new OperationAndData.ErrorCallback<String>(){

                    @Override
                    public void retriesExhausted(OperationAndData<String> operationAndData) {
                        DeleteBuilderImpl.this.client.getFailedDeleteManager().addFailedOperation(unfixedPath);
                    }
                };
            }
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), errorCallback, this.backgrounding.getContext(), null), null);
        } else {
            this.pathInForeground(path, unfixedPath);
        }
        return null;
    }

    protected int getVersion() {
        return this.version;
    }

    private void pathInForeground(final String path, String unfixedPath) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("DeleteBuilderImpl-Foreground");
        try {
            RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        DeleteBuilderImpl.this.client.getZooKeeper().delete(path, DeleteBuilderImpl.this.version);
                    }
                    catch (KeeperException.NoNodeException e) {
                        if (!DeleteBuilderImpl.this.quietly) {
                            throw e;
                        }
                    }
                    catch (KeeperException.NotEmptyException e) {
                        if (DeleteBuilderImpl.this.deletingChildrenIfNeeded) {
                            ZKPaths.deleteChildren((ZooKeeper)DeleteBuilderImpl.this.client.getZooKeeper(), (String)path, (boolean)true);
                        }
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            if ((RetryLoop.isRetryException((Throwable)e) || e instanceof InterruptedException) && this.guaranteed) {
                this.client.getFailedDeleteManager().addFailedOperation(unfixedPath);
            }
            throw e;
        }
        trace.commit();
    }
}

