/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.test.Compatibility;
import org.apache.curator.test.FailedServerStartException;
import org.apache.curator.test.QuorumConfigBuilder;
import org.apache.curator.test.Timing;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingZooKeeperMain
implements ZooKeeperMainFace {
    private static final Logger log = LoggerFactory.getLogger(TestingZooKeeperMain.class);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Exception> startingException = new AtomicReference<Object>(null);
    private volatile ServerCnxnFactory cnxnFactory;
    private volatile TestZooKeeperServer zkServer;
    private volatile ContainerManager containerManager;
    private volatile QuorumConfigBuilder configBuilder;
    private volatile int instanceIndex;
    private static final Timing timing = new Timing();
    static final int MAX_WAIT_MS;

    @Override
    public void kill() {
        try {
            if (this.cnxnFactory != null) {
                Compatibility.serverCnxnFactoryCloseAll(this.cnxnFactory);
                Field ssField = this.cnxnFactory.getClass().getDeclaredField("ss");
                ssField.setAccessible(true);
                ServerSocketChannel ss = (ServerSocketChannel)ssField.get(this.cnxnFactory);
                ss.close();
            }
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public QuorumPeerConfig getConfig() throws Exception {
        if (this.configBuilder != null) {
            return this.configBuilder.buildConfig(this.instanceIndex);
        }
        return null;
    }

    private void runFromConfig(QuorumPeerConfig config) throws Exception {
        try {
            Field instance = MBeanRegistry.class.getDeclaredField("instance");
            instance.setAccessible(true);
            MBeanRegistry nopMBeanRegistry = new MBeanRegistry(){

                public void register(ZKMBeanInfo bean, ZKMBeanInfo parent) {
                }

                public void unregister(ZKMBeanInfo bean) {
                }
            };
            instance.set(null, nopMBeanRegistry);
        }
        catch (Exception e) {
            log.error("Could not fix MBeanRegistry");
        }
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.readFrom(config);
        try {
            this.internalRunFromConfig(serverConfig);
        }
        catch (IOException e) {
            this.startingException.set(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockUntilStarted() {
        if (!timing.awaitLatch(this.latch)) {
            throw new FailedServerStartException("Timed out waiting for server startup");
        }
        if (this.zkServer != null) {
            TestZooKeeperServer testZooKeeperServer = this.zkServer;
            synchronized (testZooKeeperServer) {
                while (!this.zkServer.isRunning()) {
                    try {
                        ((Object)((Object)this.zkServer)).wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new FailedServerStartException("Server start interrupted");
                    }
                }
            }
        } else {
            throw new FailedServerStartException("No zkServer.");
        }
        Exception exception = this.startingException.get();
        if (exception != null) {
            throw new FailedServerStartException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.cnxnFactory.shutdown();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.cnxnFactory = null;
        }
        if (this.containerManager != null) {
            this.containerManager.stop();
            this.containerManager = null;
        }
        try {
            if (this.zkServer != null) {
                this.zkServer.shutdown();
                ZKDatabase zkDb = this.zkServer.getZKDatabase();
                if (zkDb != null) {
                    zkDb.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.zkServer = null;
        }
    }

    private void internalRunFromConfig(ServerConfig config) throws IOException {
        log.info("Starting server");
        try {
            FileTxnSnapLog txnLog = new FileTxnSnapLog(config.getDataLogDir(), config.getDataDir());
            this.zkServer = new TestZooKeeperServer(txnLog, config);
            try {
                this.cnxnFactory = ServerCnxnFactory.createFactory();
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            }
            catch (IOException e) {
                log.info("Could not start server. Waiting and trying one more time.", (Throwable)e);
                timing.sleepABit();
                this.cnxnFactory = ServerCnxnFactory.createFactory();
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            }
            this.cnxnFactory.startup((ZooKeeperServer)this.zkServer);
            this.containerManager = new ContainerManager(this.zkServer.getZKDatabase(), this.zkServer.getFirstProcessor(), Integer.getInteger("znode.container.checkIntervalMs", (int)TimeUnit.MINUTES.toMillis(1L)).intValue(), Integer.getInteger("znode.container.maxPerMinute", 10000).intValue());
            this.containerManager.start();
            this.latch.countDown();
            this.cnxnFactory.join();
            if (this.zkServer != null && this.zkServer.isRunning()) {
                this.zkServer.shutdown();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Server interrupted", (Throwable)e);
        }
    }

    @Override
    public void configure(QuorumConfigBuilder configBuilder, int instanceIndex) {
        this.configBuilder = configBuilder;
        this.instanceIndex = instanceIndex;
    }

    @Override
    public void start() {
        new Thread(() -> {
            try {
                this.runFromConfig(this.getConfig());
            }
            catch (Exception e) {
                log.error(String.format("From testing server (random state: %s) for instance: %s", String.valueOf(this.configBuilder.isFromRandom()), this.configBuilder.getInstanceSpec(this.instanceIndex)), (Throwable)e);
            }
        }, "zk-main-thread").start();
        this.blockUntilStarted();
    }

    static {
        long startMs = System.currentTimeMillis();
        try {
            InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        long elapsed = System.currentTimeMillis() - startMs;
        MAX_WAIT_MS = Math.max((int)elapsed * 2, 1000);
    }

    public static class TestZooKeeperServer
    extends ZooKeeperServer {
        private final FileTxnSnapLog txnLog;
        private final AtomicBoolean isRunning = new AtomicBoolean(false);

        public TestZooKeeperServer(FileTxnSnapLog txnLog, ServerConfig config) {
            this.txnLog = txnLog;
            this.setTxnLogFactory(txnLog);
            this.setTickTime(config.getTickTime());
            this.setMinSessionTimeout(config.getMinSessionTimeout());
            this.setMaxSessionTimeout(config.getMaxSessionTimeout());
        }

        public synchronized void shutdown(boolean fullyShutDown) {
            super.shutdown(fullyShutDown);
            try {
                this.txnLog.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public RequestProcessor getFirstProcessor() {
            return this.firstProcessor;
        }

        protected void setState(ZooKeeperServer.State state) {
            this.state = state;
        }

        protected void registerJMX() {
        }

        protected void unregisterJMX() {
        }

        public boolean isRunning() {
            return this.isRunning.get() || super.isRunning();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noteStartup() {
            TestZooKeeperServer testZooKeeperServer = this;
            synchronized (testZooKeeperServer) {
                this.isRunning.set(true);
                ((Object)((Object)this)).notifyAll();
            }
        }
    }
}

