/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;

public class StaticSTSProperties
implements STSPropertiesMBean {
    private static final Logger LOG = LogUtils.getL7dLogger(StaticSTSProperties.class);
    private CallbackHandler callbackHandler;
    private String callbackHandlerClass;
    private Crypto signatureCrypto;
    private String signaturePropertiesFile;
    private String signatureUsername;
    private Crypto encryptionCrypto;
    private String encryptionPropertiesFile;
    private String encryptionUsername;
    private String issuer;
    private SignatureProperties signatureProperties = new SignatureProperties();
    private RealmParser realmParser;
    private IdentityMapper identityMapper;

    public void configureProperties() throws STSException {
        if (this.signatureCrypto == null && this.signaturePropertiesFile != null) {
            Properties sigProperties = StaticSTSProperties.getProps(this.signaturePropertiesFile);
            if (sigProperties == null) {
                LOG.fine("Cannot load signature properties using: " + this.signaturePropertiesFile);
                throw new STSException("Configuration error: cannot load signature properties");
            }
            try {
                this.signatureCrypto = CryptoFactory.getInstance((Properties)sigProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the signature Crypto object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        if (this.encryptionCrypto == null && this.encryptionPropertiesFile != null) {
            Properties encrProperties = StaticSTSProperties.getProps(this.encryptionPropertiesFile);
            if (encrProperties == null) {
                LOG.fine("Cannot load encryption properties using: " + this.encryptionPropertiesFile);
                throw new STSException("Configuration error: cannot load encryption properties");
            }
            try {
                this.encryptionCrypto = CryptoFactory.getInstance((Properties)encrProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the encryption Crypto object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        if (this.callbackHandler == null && this.callbackHandlerClass != null) {
            this.callbackHandler = this.getCallbackHandler(this.callbackHandlerClass);
            if (this.callbackHandler == null) {
                LOG.fine("Cannot load CallbackHandler using: " + this.callbackHandlerClass);
                throw new STSException("Configuration error: cannot load callback handler");
            }
        }
        WSSConfig.init();
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        LOG.fine("Setting callbackHandler: " + callbackHandler);
    }

    public void setCallbackHandlerClass(String callbackHandlerClass) {
        this.callbackHandlerClass = callbackHandlerClass;
        LOG.fine("Setting callbackHandlerClass: " + callbackHandlerClass);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setSignatureCrypto(Crypto signatureCrypto) {
        this.signatureCrypto = signatureCrypto;
    }

    public void setSignaturePropertiesFile(String signaturePropertiesFile) {
        this.signaturePropertiesFile = signaturePropertiesFile;
        LOG.fine("Setting signature properties: " + signaturePropertiesFile);
    }

    public Crypto getSignatureCrypto() {
        return this.signatureCrypto;
    }

    public void setSignatureUsername(String signatureUsername) {
        this.signatureUsername = signatureUsername;
        LOG.fine("Setting signatureUsername: " + signatureUsername);
    }

    public String getSignatureUsername() {
        return this.signatureUsername;
    }

    public void setEncryptionCrypto(Crypto encryptionCrypto) {
        this.encryptionCrypto = encryptionCrypto;
    }

    public void setEncryptionPropertiesFile(String encryptionPropertiesFile) {
        this.encryptionPropertiesFile = encryptionPropertiesFile;
        LOG.fine("Setting encryptionProperties: " + encryptionPropertiesFile);
    }

    public Crypto getEncryptionCrypto() {
        return this.encryptionCrypto;
    }

    public void setEncryptionUsername(String encryptionUsername) {
        this.encryptionUsername = encryptionUsername;
        LOG.fine("Setting encryptionUsername: " + encryptionUsername);
    }

    public String getEncryptionUsername() {
        return this.encryptionUsername;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
        LOG.fine("Setting issuer: " + issuer);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setSignatureProperties(SignatureProperties signatureProperties) {
        this.signatureProperties = signatureProperties;
    }

    public SignatureProperties getSignatureProperties() {
        return this.signatureProperties;
    }

    public void setRealmParser(RealmParser realmParser) {
        this.realmParser = realmParser;
    }

    public RealmParser getRealmParser() {
        return this.realmParser;
    }

    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    public IdentityMapper getIdentityMapper() {
        return this.identityMapper;
    }

    private static Properties getProps(Object o) {
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (o instanceof String) {
            URL url = null;
            Bus bus = PhaseInterceptorChain.getCurrentMessage().getExchange().getBus();
            ResourceManager rm = (ResourceManager)bus.getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), StaticSTSProperties.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                if (url != null) {
                    properties = new Properties();
                    InputStream ins = url.openStream();
                    properties.load(ins);
                    ins.close();
                }
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
        } else if (o instanceof URL) {
            properties = new Properties();
            try {
                InputStream ins = ((URL)o).openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
        }
        return properties;
    }

    private CallbackHandler getCallbackHandler(Object o) {
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), this.getClass()).newInstance();
            }
            catch (Exception e) {
                LOG.fine(e.getMessage());
                handler = null;
            }
        }
        return handler;
    }
}

