/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.sts.cache.STSTokenStore;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInMemoryTokenStore
implements STSTokenStore {
    private Cache cache;
    private CacheManager cacheManager = CacheManager.create();
    private boolean autoRemove = true;

    public DefaultInMemoryTokenStore() {
        this.cache = new Cache("STS", 5000, false, false, 3600L, 3600L);
        this.cacheManager.addCache(this.cache);
    }

    public void add(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.cache.put(new Element((Serializable)((Object)token.getId()), (Serializable)token));
        }
    }

    @Override
    public void add(SecurityToken token, Integer timeToLiveSeconds) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.cache.put(new Element((Object)token.getId(), (Object)token, Boolean.valueOf(false), timeToLiveSeconds, timeToLiveSeconds));
        }
    }

    public void update(SecurityToken token) {
        if (this.autoRemove && (token.getState() == SecurityToken.State.EXPIRED || token.getState() == SecurityToken.State.CANCELLED)) {
            this.remove(token);
        } else {
            this.add(token);
        }
    }

    public void remove(SecurityToken token) {
        if (token != null && !StringUtils.isEmpty((String)token.getId())) {
            this.cache.remove((Serializable)((Object)token.getId()));
        }
    }

    public Collection<String> getTokenIdentifiers() {
        return this.cache.getKeys();
    }

    public Collection<SecurityToken> getExpiredTokens() {
        return null;
    }

    public Collection<SecurityToken> getValidTokens() {
        return this.cache.getAllWithLoader((Collection)this.cache.getKeysWithExpiryCheck(), null).values();
    }

    public Collection<SecurityToken> getRenewedTokens() {
        return null;
    }

    public Collection<SecurityToken> getCancelledTokens() {
        return null;
    }

    public SecurityToken getToken(String id) {
        Element element = this.cache.get((Serializable)((Object)id));
        if (element != null) {
            return (SecurityToken)element.getObjectValue();
        }
        return null;
    }

    public SecurityToken getTokenByAssociatedHash(int hashCode) {
        Iterator ids = this.cache.getKeys().iterator();
        while (ids.hasNext()) {
            SecurityToken securityToken = this.getToken((String)ids.next());
            if (hashCode != securityToken.getAssociatedHash()) continue;
            return securityToken;
        }
        return null;
    }

    public void removeExpiredTokens() {
    }

    public void removeCancelledTokens() {
    }

    public void setAutoRemoveTokens(boolean auto) {
        this.autoRemove = auto;
    }
}

