/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.sts.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.RequestClaimCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClaimsManager {
    private List<ClaimsHandler> claimHandlers;
    private List<URI> supportedClaimTypes = new ArrayList<URI>();

    public List<URI> getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    public List<ClaimsHandler> getClaimHandlers() {
        return this.claimHandlers;
    }

    public void setClaimHandlers(List<ClaimsHandler> claimHandlers) {
        this.claimHandlers = claimHandlers;
        if (claimHandlers == null) {
            this.supportedClaimTypes.clear();
        } else {
            for (ClaimsHandler handler : claimHandlers) {
                this.supportedClaimTypes.addAll(handler.getSupportedClaimTypes());
            }
        }
    }

    public ClaimCollection retrieveClaimValues(Principal principal, RequestClaimCollection claims) {
        if (this.claimHandlers != null && this.claimHandlers.size() > 0) {
            ClaimCollection returnCollection = new ClaimCollection();
            for (ClaimsHandler handler : this.claimHandlers) {
                ClaimCollection claimCollection = handler.retrieveClaimValues(principal, claims);
                if (claimCollection == null || claimCollection.size() == 0) continue;
                returnCollection.addAll(claimCollection);
            }
            return returnCollection;
        }
        return null;
    }
}

