/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.claims.Claim;
import org.apache.cxf.sts.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.claims.RequestClaimCollection;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapClaimsHandler
implements ClaimsHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(LdapClaimsHandler.class);
    private LdapTemplate ldap;
    private Map<String, String> claimMapping;
    private String userBaseDn;

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldap = ldapTemplate;
    }

    public LdapTemplate getLdapTemplate() {
        return this.ldap;
    }

    public void setClaimsLdapAttributeMapping(Map<String, String> ldapClaimMapping) {
        this.claimMapping = ldapClaimMapping;
    }

    public Map<String, String> getClaimsLdapAttributeMapping() {
        return this.claimMapping;
    }

    public void setUserBaseDN(String userBaseDN) {
        this.userBaseDn = userBaseDN;
    }

    public String getUserBaseDN() {
        return this.userBaseDn;
    }

    @Override
    public List<URI> getSupportedClaimTypes() {
        ArrayList<URI> uriList = new ArrayList<URI>();
        for (String uri : this.getClaimsLdapAttributeMapping().keySet()) {
            try {
                uriList.add(new URI(uri));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return uriList;
    }

    @Override
    public ClaimCollection retrieveClaimValues(Principal principal, RequestClaimCollection claims) {
        String dn = this.getDnOfPrincipal(principal.getName());
        ArrayList<String> searchAttributeList = new ArrayList<String>();
        for (RequestClaim claim : claims) {
            if (this.getClaimsLdapAttributeMapping().keySet().contains(claim.getClaimType().toString())) {
                searchAttributeList.add(this.getClaimsLdapAttributeMapping().get(claim.getClaimType().toString()));
                continue;
            }
            LOG.warning("Unsupported claim: " + claim.getClaimType());
        }
        String[] searchAttributes = null;
        searchAttributes = searchAttributeList.toArray(new String[0]);
        AttributesMapper mapper = new AttributesMapper(){

            public Object mapFromAttributes(Attributes attrs) throws NamingException {
                HashMap<String, String> map = new HashMap<String, String>();
                NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
                while (attrEnum.hasMore()) {
                    Attribute att = attrEnum.next();
                    map.put(att.getID(), (String)att.get());
                }
                return map;
            }
        };
        Map ldapAttributes = (Map)this.ldap.lookup(dn, searchAttributes, mapper);
        ClaimCollection claimsColl = new ClaimCollection();
        for (RequestClaim claim : claims) {
            URI claimType = claim.getClaimType();
            String ldapAttribute = this.getClaimsLdapAttributeMapping().get(claimType.toString());
            String claimValue = (String)ldapAttributes.get(ldapAttribute);
            if (claimValue == null) {
                if (!claim.isOptional()) {
                    LOG.warning("Mandatory claim not found in LDAP: " + claim.getClaimType());
                    throw new STSException("Mandatory claim '" + claim.getClaimType() + "' not found");
                }
                LOG.fine("Claim '" + claim.getClaimType() + "' is null");
                continue;
            }
            Claim c = new Claim();
            c.setClaimType(claimType);
            c.setPrincipal(principal);
            c.setValue(claimValue);
            claimsColl.add(c);
        }
        return claimsColl;
    }

    private String getDnOfPrincipal(String principal) {
        String dn = null;
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter("objectclass", "person")).and((Filter)new EqualsFilter("cn", principal));
        AttributesMapper mapper = new AttributesMapper(){

            public Object mapFromAttributes(Attributes attrs) throws NamingException {
                return attrs.get("distinguishedName").get();
            }
        };
        List users = this.ldap.search(this.userBaseDn, filter.toString(), 2, mapper);
        if (users.size() == 1) {
            dn = (String)users.get(0);
        }
        return dn;
    }
}

