/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.claims.ClaimsManager;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.claims.RequestClaimCollection;
import org.apache.cxf.sts.operation.AbstractOperation;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.RequestParser;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderResponse;
import org.apache.cxf.sts.token.provider.TokenReference;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.BinarySecretType;
import org.apache.cxf.ws.security.sts.provider.model.EntropyType;
import org.apache.cxf.ws.security.sts.provider.model.LifetimeType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseCollectionType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedProofTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.operation.IssueOperation;
import org.apache.cxf.ws.security.sts.provider.operation.IssueSingleOperation;
import org.apache.ws.security.WSSecurityException;

public class TokenIssueOperation
extends AbstractOperation
implements IssueOperation,
IssueSingleOperation {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenIssueOperation.class);
    private ClaimsManager claimsManager;

    public ClaimsManager getClaimsManager() {
        return this.claimsManager;
    }

    public void setClaimsManager(ClaimsManager claimsManager) {
        this.claimsManager = claimsManager;
    }

    public RequestSecurityTokenResponseCollectionType issue(RequestSecurityTokenType request, WebServiceContext context) {
        RequestSecurityTokenResponseType response = this.issueSingle(request, context);
        RequestSecurityTokenResponseCollectionType responseCollection = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseCollectionType();
        responseCollection.getRequestSecurityTokenResponse().add(response);
        return responseCollection;
    }

    public RequestSecurityTokenResponseType issueSingle(RequestSecurityTokenType request, WebServiceContext context) {
        RequestParser requestParser = this.parseRequest(request, context);
        TokenProviderParameters providerParameters = this.createTokenProviderParameters(requestParser, context);
        RequestClaimCollection requestedClaims = providerParameters.getRequestedClaims();
        if (requestedClaims != null) {
            ArrayList<URI> unhandledClaimTypes = new ArrayList<URI>();
            for (RequestClaim requestedClaim : requestedClaims) {
                if (this.claimsManager.getSupportedClaimTypes().contains(requestedClaim.getClaimType()) || requestedClaim.isOptional()) continue;
                unhandledClaimTypes.add(requestedClaim.getClaimType());
            }
            if (unhandledClaimTypes.size() > 0) {
                LOG.log(Level.WARNING, "The requested claim " + ((Object)unhandledClaimTypes).toString() + " cannot be fulfilled by the STS.");
                throw new STSException("The requested claim " + ((Object)unhandledClaimTypes).toString() + " cannot be fulfilled by the STS.");
            }
        }
        providerParameters.setClaimsManager(this.claimsManager);
        TokenRequirements tokenRequirements = requestParser.getTokenRequirements();
        String tokenType = tokenRequirements.getTokenType();
        TokenProviderResponse tokenResponse = null;
        String realm = providerParameters.getRealm();
        for (TokenProvider tokenProvider : this.tokenProviders) {
            if (!tokenProvider.canHandleToken(tokenType, realm)) continue;
            try {
                tokenResponse = tokenProvider.createToken(providerParameters);
                break;
            }
            catch (STSException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in providing a token", (Throwable)ex, STSException.REQUEST_FAILED);
            }
        }
        if (tokenResponse == null || tokenResponse.getToken() == null) {
            LOG.log(Level.WARNING, "No token provider found for requested token type: " + tokenType);
            throw new STSException("No token provider found for requested token type: " + tokenType, STSException.REQUEST_FAILED);
        }
        try {
            KeyRequirements keyRequirements = requestParser.getKeyRequirements();
            EncryptionProperties encryptionProperties = providerParameters.getEncryptionProperties();
            RequestSecurityTokenResponseType response = this.createResponse(encryptionProperties, tokenResponse, tokenRequirements, keyRequirements, context);
            return response;
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "", ex);
            throw new STSException("Error in creating the response", ex, STSException.REQUEST_FAILED);
        }
    }

    private RequestSecurityTokenResponseType createResponse(EncryptionProperties encryptionProperties, TokenProviderResponse tokenResponse, TokenRequirements tokenRequirements, KeyRequirements keyRequirements, WebServiceContext webServiceContext) throws WSSecurityException {
        Object token;
        JAXBElement requestedProofToken;
        RequestedProofTokenType requestedProofTokenType;
        RequestSecurityTokenResponseType response = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseType();
        String context = tokenRequirements.getContext();
        if (context != null) {
            response.setContext(context);
        }
        JAXBElement jaxbTokenType = QNameConstants.WS_TRUST_FACTORY.createTokenType(tokenRequirements.getTokenType());
        response.getAny().add(jaxbTokenType);
        RequestedSecurityTokenType requestedTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityTokenType();
        JAXBElement requestedToken = QNameConstants.WS_TRUST_FACTORY.createRequestedSecurityToken(requestedTokenType);
        LOG.fine("Encrypting Issued Token: " + this.encryptIssuedToken);
        if (!this.encryptIssuedToken) {
            requestedTokenType.setAny((Object)tokenResponse.getToken());
        } else {
            requestedTokenType.setAny((Object)this.encryptToken(tokenResponse.getToken(), tokenResponse.getTokenId(), encryptionProperties, keyRequirements, webServiceContext));
        }
        response.getAny().add(requestedToken);
        if (this.returnReferences) {
            TokenReference attachedReference = tokenResponse.getAttachedReference();
            RequestedReferenceType requestedAttachedReferenceType = null;
            requestedAttachedReferenceType = attachedReference != null ? TokenIssueOperation.createRequestedReference(attachedReference, true) : TokenIssueOperation.createRequestedReference(tokenResponse.getTokenId(), tokenRequirements.getTokenType(), true);
            JAXBElement requestedAttachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedAttachedReference(requestedAttachedReferenceType);
            response.getAny().add(requestedAttachedReference);
            TokenReference unAttachedReference = tokenResponse.getUnAttachedReference();
            RequestedReferenceType requestedUnattachedReferenceType = null;
            requestedUnattachedReferenceType = unAttachedReference != null ? TokenIssueOperation.createRequestedReference(unAttachedReference, false) : TokenIssueOperation.createRequestedReference(tokenResponse.getTokenId(), tokenRequirements.getTokenType(), false);
            JAXBElement requestedUnattachedReference = QNameConstants.WS_TRUST_FACTORY.createRequestedUnattachedReference(requestedUnattachedReferenceType);
            response.getAny().add(requestedUnattachedReference);
        }
        response.getAny().add(tokenRequirements.getAppliesTo());
        if (tokenResponse.isComputedKey() && keyRequirements.getComputedKeyAlgorithm() != null) {
            JAXBElement computedKey = QNameConstants.WS_TRUST_FACTORY.createComputedKey(keyRequirements.getComputedKeyAlgorithm());
            requestedProofTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedProofTokenType();
            requestedProofTokenType.setAny((Object)computedKey);
            requestedProofToken = QNameConstants.WS_TRUST_FACTORY.createRequestedProofToken(requestedProofTokenType);
            response.getAny().add(requestedProofToken);
        } else if (tokenResponse.getEntropy() != null) {
            token = this.constructSecretToken(tokenResponse.getEntropy(), encryptionProperties, keyRequirements);
            requestedProofTokenType = QNameConstants.WS_TRUST_FACTORY.createRequestedProofTokenType();
            requestedProofTokenType.setAny(token);
            requestedProofToken = QNameConstants.WS_TRUST_FACTORY.createRequestedProofToken(requestedProofTokenType);
            response.getAny().add(requestedProofToken);
        }
        if (tokenResponse.isComputedKey() && tokenResponse.getEntropy() != null) {
            token = this.constructSecretToken(tokenResponse.getEntropy(), encryptionProperties, keyRequirements);
            EntropyType entropyType = QNameConstants.WS_TRUST_FACTORY.createEntropyType();
            entropyType.getAny().add(token);
            JAXBElement entropyElement = QNameConstants.WS_TRUST_FACTORY.createEntropy(entropyType);
            response.getAny().add(entropyElement);
        }
        LifetimeType lifetime = TokenIssueOperation.createLifetime(tokenResponse.getLifetime());
        JAXBElement lifetimeType = QNameConstants.WS_TRUST_FACTORY.createLifetime(lifetime);
        response.getAny().add(lifetimeType);
        long keySize = tokenResponse.getKeySize();
        if (keySize <= 0L) {
            keySize = keyRequirements.getKeySize();
        }
        if (keyRequirements.getKeySize() > 0L) {
            JAXBElement keySizeType = QNameConstants.WS_TRUST_FACTORY.createKeySize(Long.valueOf(keySize));
            response.getAny().add(keySizeType);
        }
        return response;
    }

    private Object constructSecretToken(byte[] secret, EncryptionProperties encryptionProperties, KeyRequirements keyRequirements) throws WSSecurityException {
        if (this.encryptIssuedToken) {
            return this.encryptSecret(secret, encryptionProperties, keyRequirements);
        }
        BinarySecretType binarySecretType = QNameConstants.WS_TRUST_FACTORY.createBinarySecretType();
        String nonce = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Nonce";
        binarySecretType.setType(nonce);
        binarySecretType.setValue(secret);
        JAXBElement binarySecret = QNameConstants.WS_TRUST_FACTORY.createBinarySecret(binarySecretType);
        return binarySecret;
    }
}

