/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.claims.ClaimsParser;
import org.apache.cxf.sts.claims.RequestClaim;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdentityClaimsParser
implements ClaimsParser {
    public static final String IDENTITY_CLAIMS_DIALECT = "http://schemas.xmlsoap.org/ws/2005/05/identity";
    private static final Logger LOG = LogUtils.getL7dLogger(IdentityClaimsParser.class);

    public RequestClaim parse(Element claim) {
        return IdentityClaimsParser.parseClaimType(claim);
    }

    public static RequestClaim parseClaimType(Element claimType) {
        String claimLocalName = claimType.getLocalName();
        String claimNS = claimType.getNamespaceURI();
        if ("ClaimType".equals(claimLocalName)) {
            String claimTypeUri = claimType.getAttributeNS(null, "Uri");
            String claimTypeOptional = claimType.getAttributeNS(null, "Optional");
            RequestClaim requestClaim = new RequestClaim();
            try {
                requestClaim.setClaimType(new URI(claimTypeUri));
            }
            catch (URISyntaxException e) {
                LOG.log(Level.WARNING, "Cannot create URI from the given ClaimType attribute value " + claimTypeUri, e);
            }
            requestClaim.setOptional(Boolean.parseBoolean(claimTypeOptional));
            return requestClaim;
        }
        if ("ClaimValue".equals(claimLocalName)) {
            String claimTypeUri = claimType.getAttributeNS(null, "Uri");
            String claimTypeOptional = claimType.getAttributeNS(null, "Optional");
            RequestClaim requestClaim = new RequestClaim();
            try {
                requestClaim.setClaimType(new URI(claimTypeUri));
            }
            catch (URISyntaxException e) {
                LOG.log(Level.WARNING, "Cannot create URI from the given ClaimTye attribute value " + claimTypeUri, e);
            }
            Node valueNode = claimType.getFirstChild();
            if (valueNode != null) {
                if (!"Value".equals(valueNode.getLocalName())) {
                    LOG.warning("Unsupported child element of ClaimValue element " + valueNode.getLocalName());
                    return null;
                }
            } else {
                LOG.warning("No child element of ClaimValue element available");
                return null;
            }
            requestClaim.setClaimValue(valueNode.getTextContent().trim());
            requestClaim.setOptional(Boolean.parseBoolean(claimTypeOptional));
            return requestClaim;
        }
        LOG.fine("Found unknown element: " + claimLocalName + " " + claimNS);
        return null;
    }

    public String getSupportedDialect() {
        return IDENTITY_CLAIMS_DIALECT;
    }
}

