/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.w3c.dom.Element;

public class SCTValidator
implements TokenValidator {
    public static final String SCT_VALIDATOR_SECRET = "sct-validator-secret";
    private static final Logger LOG = LogUtils.getL7dLogger(SCTValidator.class);

    public boolean canHandleToken(ReceivedToken validateTarget) {
        return this.canHandleToken(validateTarget, null);
    }

    public boolean canHandleToken(ReceivedToken validateTarget, String realm) {
        Object token = validateTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("http://schemas.xmlsoap.org/ws/2005/02/sc".equals(namespace) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512".equals(namespace)) && "SecurityContextToken".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    public TokenValidatorResponse validateToken(TokenValidatorParameters tokenParameters) {
        LOG.fine("Validating SecurityContextToken");
        if (tokenParameters.getTokenStore() == null) {
            LOG.log(Level.FINE, "A cache must be configured to use the SCTValidator");
            TokenValidatorResponse response = new TokenValidatorResponse();
            response.setValid(false);
            return response;
        }
        TokenRequirements tokenRequirements = tokenParameters.getTokenRequirements();
        ReceivedToken validateTarget = tokenRequirements.getValidateTarget();
        TokenValidatorResponse response = new TokenValidatorResponse();
        response.setValid(false);
        if (validateTarget != null && validateTarget.isDOMElement()) {
            try {
                Element validateTargetElement = (Element)validateTarget.getToken();
                SecurityContextToken sct = new SecurityContextToken(validateTargetElement);
                String identifier = sct.getIdentifier();
                SecurityToken token = tokenParameters.getTokenStore().getToken(identifier);
                if (token == null) {
                    LOG.fine("Identifier: " + identifier + " is not found in the cache");
                    return response;
                }
                if (token.isExpired()) {
                    LOG.fine("Token: " + identifier + " is in the cache but expired");
                    return response;
                }
                byte[] secret = token.getSecret();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put(SCT_VALIDATOR_SECRET, secret);
                response.setAdditionalProperties(properties);
                response.setPrincipal(token.getPrincipal());
                Properties props = token.getProperties();
                if (props != null) {
                    String realm = props.getProperty("org.apache.cxf.sts.token.realm");
                    response.setTokenRealm(realm);
                }
                response.setValid(true);
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
            }
        }
        return response;
    }
}

