/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.cache.STSTokenStore;
import org.apache.cxf.sts.claims.ClaimsManager;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.claims.RequestClaimCollection;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.RequestParser;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.service.ServiceMBean;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenReference;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.LifetimeType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.model.RequestedReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.secext.KeyIdentifierType;
import org.apache.cxf.ws.security.sts.provider.model.secext.ReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.secext.SecurityTokenReferenceType;
import org.apache.cxf.ws.security.sts.provider.model.utility.AttributedDateTime;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperation {
    public static final QName TOKEN_TYPE = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType", "wsse11");
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractOperation.class);
    protected STSPropertiesMBean stsProperties;
    protected boolean encryptIssuedToken;
    protected List<ServiceMBean> services;
    protected List<TokenProvider> tokenProviders = new ArrayList<TokenProvider>();
    protected List<TokenValidator> tokenValidators = new ArrayList<TokenValidator>();
    protected boolean returnReferences = true;
    protected STSTokenStore tokenStore;
    protected ClaimsManager claimsManager;

    public boolean isReturnReferences() {
        return this.returnReferences;
    }

    public void setReturnReferences(boolean returnReferences) {
        this.returnReferences = returnReferences;
    }

    public STSTokenStore getTokenStore() {
        return this.tokenStore;
    }

    public void setTokenStore(STSTokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setStsProperties(STSPropertiesMBean stsProperties) {
        this.stsProperties = stsProperties;
    }

    public void setEncryptIssuedToken(boolean encryptIssuedToken) {
        this.encryptIssuedToken = encryptIssuedToken;
    }

    public void setServices(List<ServiceMBean> services) {
        this.services = services;
    }

    public void setTokenProviders(List<TokenProvider> tokenProviders) {
        this.tokenProviders = tokenProviders;
    }

    public List<TokenProvider> getTokenProviders() {
        return this.tokenProviders;
    }

    public void setTokenValidators(List<TokenValidator> tokenValidators) {
        this.tokenValidators = tokenValidators;
    }

    public List<TokenValidator> getTokenValidators() {
        return this.tokenValidators;
    }

    public ClaimsManager getClaimsManager() {
        return this.claimsManager;
    }

    public void setClaimsManager(ClaimsManager claimsManager) {
        this.claimsManager = claimsManager;
    }

    protected RequestParser parseRequest(RequestSecurityTokenType request, WebServiceContext context) {
        if (context == null || context.getMessageContext() == null) {
            throw new STSException("No message context found");
        }
        if (this.stsProperties == null) {
            throw new STSException("No STSProperties object found");
        }
        this.stsProperties.configureProperties();
        RequestParser requestParser = new RequestParser();
        requestParser.parseRequest(request, context);
        return requestParser;
    }

    protected static RequestedReferenceType createRequestedReference(TokenReference tokenReference, boolean attached) {
        RequestedReferenceType requestedReferenceType = QNameConstants.WS_TRUST_FACTORY.createRequestedReferenceType();
        SecurityTokenReferenceType securityTokenReferenceType = QNameConstants.WSSE_FACTORY.createSecurityTokenReferenceType();
        String identifier = tokenReference.getIdentifier();
        if (attached && identifier.charAt(0) != '#') {
            identifier = "#" + identifier;
        } else if (!attached && identifier.charAt(0) == '#') {
            identifier = identifier.substring(1);
        }
        String tokenType = tokenReference.getWsse11TokenType();
        if (tokenType != null) {
            securityTokenReferenceType.getOtherAttributes().put(TOKEN_TYPE, tokenType);
        }
        if (tokenReference.isUseKeyIdentifier()) {
            KeyIdentifierType keyIdentifierType = QNameConstants.WSSE_FACTORY.createKeyIdentifierType();
            keyIdentifierType.setValue(identifier);
            String valueType = tokenReference.getWsseValueType();
            if (valueType != null) {
                keyIdentifierType.setValueType(valueType);
            }
            JAXBElement keyIdentifier = QNameConstants.WSSE_FACTORY.createKeyIdentifier(keyIdentifierType);
            securityTokenReferenceType.getAny().add(keyIdentifier);
        } else if (tokenReference.isUseDirectReference()) {
            ReferenceType referenceType = QNameConstants.WSSE_FACTORY.createReferenceType();
            referenceType.setURI(identifier);
            String valueType = tokenReference.getWsseValueType();
            if (valueType != null) {
                referenceType.setValueType(valueType);
            }
            JAXBElement reference = QNameConstants.WSSE_FACTORY.createReference(referenceType);
            securityTokenReferenceType.getAny().add(reference);
        }
        requestedReferenceType.setSecurityTokenReference(securityTokenReferenceType);
        return requestedReferenceType;
    }

    protected static RequestedReferenceType createRequestedReference(String tokenId, String tokenType, boolean attached) {
        TokenReference tokenReference = new TokenReference();
        tokenReference.setIdentifier(tokenId);
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType)) {
            tokenReference.setWsse11TokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            tokenReference.setUseKeyIdentifier(true);
            tokenReference.setWsseValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            tokenReference.setWsse11TokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            tokenReference.setUseKeyIdentifier(true);
            tokenReference.setWsseValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        } else {
            tokenReference.setUseDirectReference(true);
            tokenReference.setWsseValueType(tokenType);
        }
        return AbstractOperation.createRequestedReference(tokenReference, attached);
    }

    protected static LifetimeType createLifetime(long lifetime) {
        AttributedDateTime created = QNameConstants.UTIL_FACTORY.createAttributedDateTime();
        AttributedDateTime expires = QNameConstants.UTIL_FACTORY.createAttributedDateTime();
        Date creationTime = new Date();
        Date expirationTime = new Date();
        if (lifetime <= 0L) {
            lifetime = 300L;
        }
        expirationTime.setTime(creationTime.getTime() + lifetime * 1000L);
        XmlSchemaDateFormat fmt = new XmlSchemaDateFormat();
        created.setValue(fmt.format(creationTime));
        LOG.fine("Token lifetime creation: " + created.getValue());
        expires.setValue(fmt.format(expirationTime));
        LOG.fine("Token lifetime expiration: " + expires.getValue());
        LifetimeType lifetimeType = QNameConstants.WS_TRUST_FACTORY.createLifetimeType();
        lifetimeType.setCreated(created);
        lifetimeType.setExpires(expires);
        return lifetimeType;
    }

    protected Element encryptToken(Element element, String id, EncryptionProperties encryptionProperties, KeyRequirements keyRequirements, WebServiceContext context) throws WSSecurityException {
        String name = encryptionProperties.getEncryptionName();
        if (name == null) {
            name = this.stsProperties.getEncryptionUsername();
        }
        if (name == null) {
            throw new STSException("No encryption alias is configured", STSException.REQUEST_FAILED);
        }
        String encryptionAlgorithm = keyRequirements.getEncryptionAlgorithm();
        if (encryptionAlgorithm == null) {
            encryptionAlgorithm = encryptionProperties.getEncryptionAlgorithm();
        } else {
            List<String> supportedAlgorithms = encryptionProperties.getAcceptedEncryptionAlgorithms();
            if (!supportedAlgorithms.contains(encryptionAlgorithm)) {
                encryptionAlgorithm = encryptionProperties.getEncryptionAlgorithm();
                LOG.fine("EncryptionAlgorithm not supported, defaulting to: " + encryptionAlgorithm);
            }
        }
        String keyWrapAlgorithm = keyRequirements.getKeywrapAlgorithm();
        if (keyWrapAlgorithm == null) {
            keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
        } else {
            List<String> supportedAlgorithms = encryptionProperties.getAcceptedKeyWrapAlgorithms();
            if (!supportedAlgorithms.contains(keyWrapAlgorithm)) {
                keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
                LOG.fine("KeyWrapAlgorithm not supported, defaulting to: " + keyWrapAlgorithm);
            }
        }
        WSSecEncrypt builder = new WSSecEncrypt();
        if ("useReqSigCert".equals(name)) {
            X509Certificate cert = this.getReqSigCert(context.getMessageContext());
            builder.setUseThisCert(cert);
        } else {
            builder.setUserInfo(name);
        }
        builder.setKeyIdentifierType(encryptionProperties.getKeyIdentifierType());
        builder.setSymmetricEncAlgorithm(encryptionAlgorithm);
        builder.setKeyEncAlgo(keyWrapAlgorithm);
        builder.setEmbedEncryptedKey(true);
        WSEncryptionPart encryptionPart = new WSEncryptionPart(id, "Element");
        encryptionPart.setElement(element);
        Document doc = element.getOwnerDocument();
        doc.appendChild(element);
        builder.prepare(element.getOwnerDocument(), this.stsProperties.getEncryptionCrypto());
        builder.encryptForRef(null, Collections.singletonList(encryptionPart));
        return doc.getDocumentElement();
    }

    protected Element encryptSecret(byte[] secret, EncryptionProperties encryptionProperties, KeyRequirements keyRequirements) throws WSSecurityException {
        String name = encryptionProperties.getEncryptionName();
        if (name == null) {
            name = this.stsProperties.getEncryptionUsername();
        }
        if (name == null) {
            throw new STSException("No encryption alias is configured", STSException.REQUEST_FAILED);
        }
        String keyWrapAlgorithm = keyRequirements.getKeywrapAlgorithm();
        if (keyWrapAlgorithm == null) {
            keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
        } else {
            List<String> supportedAlgorithms = encryptionProperties.getAcceptedKeyWrapAlgorithms();
            if (!supportedAlgorithms.contains(keyWrapAlgorithm)) {
                keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
                LOG.fine("KeyWrapAlgorithm not supported, defaulting to: " + keyWrapAlgorithm);
            }
        }
        WSSecEncryptedKey builder = new WSSecEncryptedKey();
        builder.setUserInfo(name);
        builder.setKeyIdentifierType(encryptionProperties.getKeyIdentifierType());
        builder.setEphemeralKey(secret);
        builder.setKeyEncAlgo(keyWrapAlgorithm);
        Document doc = DOMUtils.createDocument();
        builder.prepare(doc, this.stsProperties.getEncryptionCrypto());
        return builder.getEncryptedKeyElement();
    }

    protected static String extractAddressFromAppliesTo(Element appliesTo) {
        Element endpointRef;
        LOG.fine("Parsing AppliesTo element");
        if (appliesTo != null && (endpointRef = DOMUtils.getFirstChildWithName((Element)appliesTo, (String)"http://www.w3.org/2005/08/addressing", (String)"EndpointReference")) != null) {
            LOG.fine("Found EndpointReference element");
            Element address = DOMUtils.getFirstChildWithName((Element)endpointRef, (String)"http://www.w3.org/2005/08/addressing", (String)"Address");
            if (address != null) {
                LOG.fine("Found address element");
                return address.getTextContent();
            }
        }
        LOG.fine("AppliesTo element does not exist or could not be parsed");
        return null;
    }

    protected TokenProviderParameters createTokenProviderParameters(RequestParser requestParser, WebServiceContext context) {
        TokenProviderParameters providerParameters = new TokenProviderParameters();
        providerParameters.setStsProperties(this.stsProperties);
        providerParameters.setPrincipal(context.getUserPrincipal());
        providerParameters.setWebServiceContext(context);
        providerParameters.setTokenStore(this.getTokenStore());
        KeyRequirements keyRequirements = requestParser.getKeyRequirements();
        TokenRequirements tokenRequirements = requestParser.getTokenRequirements();
        providerParameters.setKeyRequirements(keyRequirements);
        providerParameters.setTokenRequirements(tokenRequirements);
        String address = AbstractOperation.extractAddressFromAppliesTo(tokenRequirements.getAppliesTo());
        LOG.fine("The AppliesTo address that has been received is: " + address);
        providerParameters.setAppliesToAddress(address);
        if (this.stsProperties.getRealmParser() != null) {
            RealmParser realmParser = this.stsProperties.getRealmParser();
            String realm = realmParser.parseRealm(context);
            providerParameters.setRealm(realm);
        }
        RequestClaimCollection claims = tokenRequirements.getClaims();
        providerParameters.setRequestedClaims(claims);
        EncryptionProperties encryptionProperties = this.stsProperties.getEncryptionProperties();
        if (address != null) {
            boolean foundService = false;
            if (this.services != null) {
                for (ServiceMBean service : this.services) {
                    if (!service.isAddressInEndpoints(address)) continue;
                    EncryptionProperties svcEncryptionProperties = service.getEncryptionProperties();
                    if (svcEncryptionProperties != null) {
                        encryptionProperties = svcEncryptionProperties;
                    }
                    if (tokenRequirements.getTokenType() == null) {
                        String tokenType = service.getTokenType();
                        tokenRequirements.setTokenType(tokenType);
                        LOG.fine("Using default token type of: " + tokenType);
                    }
                    if (keyRequirements.getKeyType() == null) {
                        String keyType = service.getKeyType();
                        keyRequirements.setKeyType(keyType);
                        LOG.fine("Using default key type of: " + keyType);
                    }
                    foundService = true;
                    break;
                }
            }
            if (!foundService) {
                LOG.log(Level.WARNING, "The Service cannot match the received AppliesTo address");
                throw new STSException("No service corresponding to " + address + " is known", STSException.REQUEST_FAILED);
            }
        }
        providerParameters.setEncryptionProperties(encryptionProperties);
        return providerParameters;
    }

    private X509Certificate getReqSigCert(MessageContext context) {
        List results = (List)context.get((Object)"RECV_RESULTS");
        if (results != null) {
            for (WSHandlerResult rResult : results) {
                List wsSecEngineResults = rResult.getResults();
                for (WSSecurityEngineResult wser : wsSecEngineResults) {
                    X509Certificate cert;
                    int wserAction = (Integer)wser.get((Object)"action");
                    if (wserAction != 2 || (cert = (X509Certificate)wser.get((Object)"x509-certificate")) == null) continue;
                    return cert;
                }
            }
        }
        return null;
    }

    protected TokenValidatorResponse validateReceivedToken(WebServiceContext context, String realm, TokenRequirements tokenRequirements, ReceivedToken token) {
        token.setValidationState(ReceivedToken.STATE.NONE);
        tokenRequirements.setValidateTarget(token);
        TokenValidatorParameters validatorParameters = new TokenValidatorParameters();
        validatorParameters.setStsProperties(this.stsProperties);
        validatorParameters.setPrincipal(context.getUserPrincipal());
        validatorParameters.setWebServiceContext(context);
        validatorParameters.setTokenStore(this.getTokenStore());
        validatorParameters.setKeyRequirements(null);
        validatorParameters.setTokenRequirements(tokenRequirements);
        TokenValidatorResponse tokenResponse = null;
        for (TokenValidator tokenValidator : this.tokenValidators) {
            boolean canHandle = false;
            canHandle = realm == null ? tokenValidator.canHandleToken(token) : tokenValidator.canHandleToken(token, realm);
            if (!canHandle) continue;
            try {
                tokenResponse = tokenValidator.validateToken(validatorParameters);
                token.setValidationState(tokenResponse.isValid() ? ReceivedToken.STATE.VALID : ReceivedToken.STATE.INVALID);
                token.setPrincipal(tokenResponse.getPrincipal());
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, "Failed to validate the token", ex);
                token.setValidationState(ReceivedToken.STATE.INVALID);
            }
            break;
        }
        return tokenResponse;
    }

    protected void checkClaimsSupport(RequestClaimCollection requestedClaims) {
        if (requestedClaims != null) {
            ArrayList<URI> unhandledClaimTypes = new ArrayList<URI>();
            for (RequestClaim requestedClaim : requestedClaims) {
                if (this.claimsManager.getSupportedClaimTypes().contains(requestedClaim.getClaimType()) || requestedClaim.isOptional()) continue;
                unhandledClaimTypes.add(requestedClaim.getClaimType());
            }
            if (unhandledClaimTypes.size() > 0) {
                LOG.log(Level.WARNING, "The requested claim " + ((Object)unhandledClaimTypes).toString() + " cannot be fulfilled by the STS.");
                throw new STSException("The requested claim " + ((Object)unhandledClaimTypes).toString() + " cannot be fulfilled by the STS.");
            }
        }
    }
}

