/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.realm.CertConstraintsParser;
import org.apache.cxf.sts.token.realm.SAMLRealmCodec;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.SAMLTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SignatureTrustValidator;
import org.apache.ws.security.validate.Validator;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLTokenValidator
implements TokenValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLTokenValidator.class);
    private Validator validator = new SignatureTrustValidator();
    private CertConstraintsParser certConstraints = new CertConstraintsParser();
    private SAMLRealmCodec samlRealmCodec;

    public void setSubjectConstraints(List<String> subjectConstraints) {
        this.certConstraints.setSubjectConstraints(subjectConstraints);
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setSamlRealmCodec(SAMLRealmCodec samlRealmCodec) {
        this.samlRealmCodec = samlRealmCodec;
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget) {
        return this.canHandleToken(validateTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget, String realm) {
        Object token = validateTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(namespace)) && "Assertion".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public TokenValidatorResponse validateToken(TokenValidatorParameters tokenParameters) {
        LOG.fine("Validating SAML Token");
        TokenRequirements tokenRequirements = tokenParameters.getTokenRequirements();
        ReceivedToken validateTarget = tokenRequirements.getValidateTarget();
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        Crypto sigCrypto = stsProperties.getSignatureCrypto();
        CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
        TokenValidatorResponse response = new TokenValidatorResponse();
        response.setValid(false);
        if (validateTarget == null || !validateTarget.isDOMElement()) {
            return response;
        }
        try {
            Element validateTargetElement = (Element)validateTarget.getToken();
            AssertionWrapper assertion = new AssertionWrapper(validateTargetElement);
            SAMLTokenPrincipal samlPrincipal = new SAMLTokenPrincipal(assertion);
            response.setPrincipal((Principal)samlPrincipal);
            SecurityToken secToken = null;
            if (tokenParameters.getTokenStore() != null) {
                int hash = 0;
                byte[] signatureValue = assertion.getSignatureValue();
                if (signatureValue != null && signatureValue.length > 0) {
                    hash = Arrays.hashCode(signatureValue);
                    secToken = tokenParameters.getTokenStore().getTokenByAssociatedHash(hash);
                }
            }
            if (secToken == null) {
                if (!assertion.isSigned()) {
                    LOG.log(Level.WARNING, "The received assertion is not signed, and therefore not trusted");
                    return response;
                }
                RequestData requestData = new RequestData();
                requestData.setSigCrypto(sigCrypto);
                WSSConfig wssConfig = WSSConfig.getNewInstance();
                requestData.setWssConfig(wssConfig);
                requestData.setCallbackHandler(callbackHandler);
                assertion.verifySignature(requestData, new WSDocInfo(validateTargetElement.getOwnerDocument()));
                Credential trustCredential = new Credential();
                SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
                trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
                trustCredential.setCertificates(samlKeyInfo.getCerts());
                this.validator.validate(trustCredential, requestData);
                X509Certificate cert = null;
                if (trustCredential.getCertificates() != null) {
                    cert = trustCredential.getCertificates()[0];
                }
                if (!this.certConstraints.matches(cert)) {
                    return response;
                }
            }
            DateTime validFrom = null;
            DateTime validTill = null;
            if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
                validFrom = assertion.getSaml2().getConditions().getNotBefore();
                validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
            } else {
                validFrom = assertion.getSaml1().getConditions().getNotBefore();
                validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
            }
            if (validFrom.isAfterNow() || validTill.isBeforeNow()) {
                LOG.log(Level.WARNING, "SAML Token condition not met");
                if (secToken != null) {
                    tokenParameters.getTokenStore().remove(secToken);
                }
                return response;
            }
            String tokenRealm = null;
            if (this.samlRealmCodec != null) {
                String cachedRealm;
                Properties props;
                tokenRealm = this.samlRealmCodec.getRealmFromToken(assertion);
                if (secToken != null && (props = secToken.getProperties()) != null && !tokenRealm.equals(cachedRealm = props.getProperty("org.apache.cxf.sts.token.realm"))) {
                    return response;
                }
            }
            response.setTokenRealm(tokenRealm);
            response.setValid(true);
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        return response;
    }
}

