/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.service.ServiceMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticService
implements ServiceMBean {
    private static final Logger LOG = LogUtils.getL7dLogger(StaticService.class);
    private String tokenType;
    private String keyType;
    private EncryptionProperties encryptionProperties;
    private final Collection<Pattern> endpointPatterns = new ArrayList<Pattern>();

    @Override
    public boolean isAddressInEndpoints(String address) {
        String addressToMatch = address;
        if (addressToMatch == null) {
            addressToMatch = "";
        }
        for (Pattern endpointPattern : this.endpointPatterns) {
            Matcher matcher = endpointPattern.matcher(addressToMatch);
            if (!matcher.matches()) continue;
            LOG.fine("Address " + address + " matches with pattern " + endpointPattern);
            return true;
        }
        return false;
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
        LOG.fine("Setting Token Type: " + tokenType);
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public void setKeyType(String keyType) {
        this.keyType = keyType;
        LOG.fine("Setting Key Type: " + keyType);
    }

    @Override
    public void setEndpoints(List<String> endpoints) {
        if (endpoints != null) {
            for (String endpoint : endpoints) {
                try {
                    this.endpointPatterns.add(Pattern.compile(endpoint.trim()));
                }
                catch (PatternSyntaxException ex) {
                    LOG.severe(ex.getMessage());
                    throw ex;
                }
            }
        }
    }

    @Override
    public EncryptionProperties getEncryptionProperties() {
        return this.encryptionProperties;
    }

    @Override
    public void setEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        LOG.fine("Setting encryption properties");
    }
}

