/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.canceller;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.canceller.TokenCanceller;
import org.apache.cxf.sts.token.canceller.TokenCancellerParameters;
import org.apache.cxf.sts.token.canceller.TokenCancellerResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.w3c.dom.Element;

public class SCTCanceller
implements TokenCanceller {
    private static final Logger LOG = LogUtils.getL7dLogger(SCTCanceller.class);
    private boolean verifyProofOfPossession = true;

    public boolean canHandleToken(ReceivedToken targetToken) {
        Object token = targetToken.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("http://schemas.xmlsoap.org/ws/2005/02/sc".equals(namespace) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512".equals(namespace)) && "SecurityContextToken".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    public TokenCancellerResponse cancelToken(TokenCancellerParameters tokenParameters) {
        LOG.fine("Trying to cancel a SecurityContextToken");
        TokenCancellerResponse response = new TokenCancellerResponse();
        ReceivedToken cancelTarget = tokenParameters.getToken();
        cancelTarget.setState(ReceivedToken.STATE.NONE);
        response.setToken(cancelTarget);
        if (tokenParameters.getTokenStore() == null) {
            LOG.log(Level.FINE, "A cache must be configured to use the SCTCanceller");
            return response;
        }
        if (cancelTarget != null && cancelTarget.isDOMElement()) {
            try {
                Element cancelTargetElement = (Element)cancelTarget.getToken();
                SecurityContextToken sct = new SecurityContextToken(cancelTargetElement);
                String identifier = sct.getIdentifier();
                SecurityToken token = tokenParameters.getTokenStore().getToken(identifier);
                if (token == null) {
                    LOG.fine("Identifier: " + identifier + " is not found in the cache");
                    return response;
                }
                if (this.verifyProofOfPossession && !this.matchKey(tokenParameters, token.getSecret())) {
                    throw new STSException("Failed to verify the proof of possession of the key associated with the security context. No matching key found in the request.", STSException.INVALID_REQUEST);
                }
                tokenParameters.getTokenStore().remove(token.getId());
                cancelTarget.setState(ReceivedToken.STATE.CANCELLED);
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
            }
        }
        return response;
    }

    private boolean matchKey(TokenCancellerParameters tokenParameters, byte[] secretKey) {
        boolean result = false;
        MessageContext messageContext = tokenParameters.getWebServiceContext().getMessageContext();
        List handlerResults = CastUtils.cast((List)((List)messageContext.get((Object)"RECV_RESULTS")));
        if (handlerResults != null && handlerResults.size() > 0) {
            WSHandlerResult handlerResult = (WSHandlerResult)handlerResults.get(0);
            List engineResults = handlerResult.getResults();
            for (WSSecurityEngineResult engineResult : engineResults) {
                byte[] receivedKey;
                Integer action = (Integer)engineResult.get((Object)"action");
                if (!action.equals(2) || !Arrays.equals(secretKey, receivedKey = (byte[])engineResult.get((Object)"secret"))) continue;
                LOG.log(Level.FINE, "Verification of the proof of possession of the key associated with the security context successful.");
                return true;
            }
        }
        return result;
    }

    public void setVerifyProofOfPossession(boolean verifyProofOfPossession) {
        this.verifyProofOfPossession = verifyProofOfPossession;
    }
}

