/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.request.BinarySecret;
import org.apache.cxf.sts.request.Entropy;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.util.WSSecurityUtil;

public class SymmetricKeyHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(SymmetricKeyHandler.class);
    private int keySize = 256;
    private Entropy clientEntropy;
    private byte[] entropyBytes;
    private byte[] secret;
    private boolean computedKey;

    /*
     * Enabled aggressive block sorting
     */
    public SymmetricKeyHandler(TokenProviderParameters tokenParameters) {
        KeyRequirements keyRequirements = tokenParameters.getKeyRequirements();
        this.keySize = Long.valueOf(keyRequirements.getKeySize()).intValue();
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        SignatureProperties signatureProperties = stsProperties.getSignatureProperties();
        if ((long)this.keySize < signatureProperties.getMinimumKeySize() || (long)this.keySize > signatureProperties.getMaximumKeySize()) {
            this.keySize = Long.valueOf(signatureProperties.getKeySize()).intValue();
            LOG.log(Level.WARNING, "Received KeySize of " + keyRequirements.getKeySize() + " not accepted so defaulting to " + signatureProperties.getKeySize());
        }
        this.clientEntropy = keyRequirements.getEntropy();
        if (this.clientEntropy == null) {
            LOG.log(Level.WARNING, "A SymmetricKey KeyType is requested, but no client entropy is provided");
            return;
        }
        if (this.clientEntropy.getBinarySecret() != null) {
            BinarySecret binarySecret = this.clientEntropy.getBinarySecret();
            if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Nonce".equals(binarySecret.getBinarySecretType())) {
                String computedKeyAlgorithm;
                byte[] nonce = binarySecret.getBinarySecretValue();
                if (nonce == null || nonce.length < this.keySize / 8) {
                    LOG.log(Level.WARNING, "User Entropy rejected");
                    this.clientEntropy = null;
                }
                if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/CK/PSHA1".equals(computedKeyAlgorithm = keyRequirements.getComputedKeyAlgorithm())) return;
                LOG.log(Level.WARNING, "The computed key algorithm of " + computedKeyAlgorithm + " is not supported");
                throw new STSException("Computed Key Algorithm not supported", STSException.INVALID_REQUEST);
            }
            if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(binarySecret.getBinarySecretType()) && binarySecret.getBinarySecretType() != null) {
                LOG.log(Level.WARNING, "The type " + binarySecret.getBinarySecretType() + " is not supported");
                throw new STSException("No user supplied entropy for SymmetricKey case", STSException.INVALID_REQUEST);
            }
            byte[] secretValue = binarySecret.getBinarySecretValue();
            if ((long)secretValue.length * 8L >= signatureProperties.getMinimumKeySize()) {
                if ((long)secretValue.length * 8L <= signatureProperties.getMaximumKeySize()) return;
            }
            LOG.log(Level.WARNING, "Received secret of length " + this.secret.length + " bits is not accepted");
            LOG.log(Level.WARNING, "User Entropy rejected");
            this.clientEntropy = null;
            return;
        }
        if (this.clientEntropy.getDecryptedKey() == null) {
            LOG.log(Level.WARNING, "The user supplied Entropy structure is invalid");
            throw new STSException("The user supplied Entropy structure is invalid", STSException.INVALID_REQUEST);
        }
        byte[] secretValue = this.clientEntropy.getDecryptedKey();
        if ((long)secretValue.length * 8L >= signatureProperties.getMinimumKeySize()) {
            if ((long)secretValue.length * 8L <= signatureProperties.getMaximumKeySize()) return;
        }
        LOG.log(Level.WARNING, "Received secret of length " + this.secret.length + " bits is not accepted");
        LOG.log(Level.WARNING, "User Entropy rejected");
        this.clientEntropy = null;
    }

    public void createSymmetricKey() {
        this.computedKey = false;
        boolean generateEntropy = true;
        if (this.clientEntropy != null) {
            BinarySecret binarySecret = this.clientEntropy.getBinarySecret();
            if (binarySecret != null && ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(binarySecret.getBinarySecretType()) || binarySecret.getBinarySecretType() == null)) {
                this.secret = binarySecret.getBinarySecretValue();
                generateEntropy = false;
            } else if (this.clientEntropy.getDecryptedKey() != null) {
                this.secret = this.clientEntropy.getDecryptedKey();
                generateEntropy = false;
            }
        }
        if (generateEntropy) {
            try {
                this.entropyBytes = WSSecurityUtil.generateNonce((int)(this.keySize / 8));
                this.secret = this.entropyBytes;
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException("Error in creating symmetric key", (Throwable)ex, STSException.INVALID_REQUEST);
            }
            if (this.clientEntropy != null && this.clientEntropy.getBinarySecret() != null) {
                byte[] nonce = this.clientEntropy.getBinarySecret().getBinarySecretValue();
                try {
                    P_SHA1 psha1 = new P_SHA1();
                    this.secret = psha1.createKey(nonce, this.entropyBytes, 0, (long)(this.keySize / 8));
                    this.computedKey = true;
                }
                catch (ConversationException ex) {
                    LOG.log(Level.WARNING, "", ex);
                    throw new STSException("Error in creating symmetric key", STSException.INVALID_REQUEST);
                }
            }
        }
    }

    public long getKeySize() {
        return this.keySize;
    }

    public byte[] getEntropyBytes() {
        return this.entropyBytes;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public boolean isComputedKey() {
        return this.computedKey;
    }
}

