/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.claims.Claim;
import org.apache.cxf.sts.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsMapper;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ClaimsParser;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.claims.RequestClaimCollection;
import org.apache.cxf.sts.token.realm.Relationship;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClaimsManager {
    private static final Logger LOG = LogUtils.getL7dLogger(ClaimsManager.class);
    private List<ClaimsParser> claimParsers;
    private List<ClaimsHandler> claimHandlers;
    private List<URI> supportedClaimTypes = new ArrayList<URI>();

    public List<URI> getSupportedClaimTypes() {
        return this.supportedClaimTypes;
    }

    public List<ClaimsParser> getClaimParsers() {
        return this.claimParsers;
    }

    public List<ClaimsHandler> getClaimHandlers() {
        return this.claimHandlers;
    }

    public void setClaimParsers(List<ClaimsParser> claimParsers) {
        this.claimParsers = claimParsers;
    }

    public void setClaimHandlers(List<ClaimsHandler> claimHandlers) {
        this.claimHandlers = claimHandlers;
        if (claimHandlers == null) {
            this.supportedClaimTypes.clear();
        } else {
            for (ClaimsHandler handler : claimHandlers) {
                this.supportedClaimTypes.addAll(handler.getSupportedClaimTypes());
            }
        }
    }

    public ClaimCollection retrieveClaimValues(RequestClaimCollection claims, ClaimsParameters parameters) {
        Relationship relationship = null;
        if (parameters.getAdditionalProperties() != null) {
            relationship = (Relationship)parameters.getAdditionalProperties().get(Relationship.class.getName());
        }
        if (relationship == null || relationship.getType().equals("FederatedIdentity")) {
            if (this.claimHandlers != null && this.claimHandlers.size() > 0 && claims != null && claims.size() > 0) {
                ClaimCollection returnCollection = new ClaimCollection();
                for (ClaimsHandler handler : this.claimHandlers) {
                    ClaimCollection claimCollection = handler.retrieveClaimValues(claims, parameters);
                    if (claimCollection == null || claimCollection.size() == 0) continue;
                    returnCollection.addAll(claimCollection);
                }
                this.validateClaimValues(claims, returnCollection);
                return returnCollection;
            }
        } else {
            ClaimsMapper claimsMapper = relationship.getClaimsMapper();
            if (claimsMapper == null) {
                LOG.log(Level.SEVERE, "ClaimsMapper required to federate claims but not configured.");
                throw new STSException("ClaimsMapper required to federate claims but not configured", STSException.BAD_REQUEST);
            }
            AssertionWrapper assertion = (AssertionWrapper)parameters.getAdditionalProperties().get(AssertionWrapper.class.getName());
            List<Claim> claimList = null;
            claimList = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? this.parseClaimsInAssertion(assertion.getSaml2()) : this.parseClaimsInAssertion(assertion.getSaml1());
            ClaimCollection sourceClaims = new ClaimCollection();
            sourceClaims.addAll(claimList);
            ClaimCollection targetClaims = claimsMapper.mapClaims(relationship.getSourceRealm(), sourceClaims, relationship.getTargetRealm(), parameters);
            this.validateClaimValues(claims, targetClaims);
            return targetClaims;
        }
        return null;
    }

    private boolean validateClaimValues(RequestClaimCollection requestedClaims, ClaimCollection claims) {
        for (RequestClaim claim : requestedClaims) {
            URI claimType = claim.getClaimType();
            boolean found = false;
            if (claim.isOptional()) continue;
            for (Claim c : claims) {
                if (c.getClaimType().equals(claimType)) {
                    found = true;
                    break;
                }
                StringBuffer sb = new StringBuffer();
                sb.append(c.getNamespace()).append('/').append(c.getClaimType());
                if (!sb.toString().equals(claimType.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            LOG.warning("Mandatory claim not found: " + claim.getClaimType());
            throw new STSException("Mandatory claim '" + claim.getClaimType() + "' not found");
        }
        return true;
    }

    protected List<Claim> parseClaimsInAssertion(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("No attribute statements found");
            }
            return Collections.emptyList();
        }
        ClaimCollection collection = new ClaimCollection();
        for (org.opensaml.saml1.core.AttributeStatement statement : attributeStatements) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("parsing statement: " + statement.getElementQName());
            }
            List attributes = statement.getAttributes();
            for (org.opensaml.saml1.core.Attribute attribute : attributes) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("parsing attribute: " + attribute.getAttributeName());
                }
                Claim c = new Claim();
                c.setIssuer(assertion.getIssuer());
                c.setClaimType(URI.create(attribute.getAttributeName()));
                try {
                    c.setClaimType(new URI(attribute.getAttributeName()));
                }
                catch (URISyntaxException e) {
                    LOG.warning("Invalid attribute name in attributestatement: " + e.getMessage());
                    continue;
                }
                Iterator i$ = attribute.getAttributeValues().iterator();
                if (!i$.hasNext()) continue;
                XMLObject attributeValue = (XMLObject)i$.next();
                Element attributeValueElement = attributeValue.getDOM();
                String value = attributeValueElement.getTextContent();
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest(" [" + value + "]");
                }
                c.setValue(value);
                collection.add(c);
            }
        }
        return collection;
    }

    protected List<Claim> parseClaimsInAssertion(org.opensaml.saml2.core.Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("No attribute statements found");
            }
            return Collections.emptyList();
        }
        ArrayList<Claim> collection = new ArrayList<Claim>();
        for (AttributeStatement statement : attributeStatements) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("parsing statement: " + statement.getElementQName());
            }
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("parsing attribute: " + attribute.getName());
                }
                Claim c = new Claim();
                c.setClaimType(URI.create(attribute.getName()));
                c.setIssuer(assertion.getIssuer().getNameQualifier());
                Iterator i$ = attribute.getAttributeValues().iterator();
                if (!i$.hasNext()) continue;
                XMLObject attributeValue = (XMLObject)i$.next();
                Element attributeValueElement = attributeValue.getDOM();
                String value = attributeValueElement.getTextContent();
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest(" [" + value + "]");
                }
                c.setValue(value);
                collection.add(c);
            }
        }
        return collection;
    }
}

