/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.cache.IdentityCache;
import org.apache.cxf.sts.cache.MemoryIdentityCacheStatistics;
import org.apache.cxf.ws.security.cache.EHCacheManagerHolder;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.ws.security.CustomTokenPrincipal;

@ManagedResource
public class EHCacheIdentityCache
implements IdentityCache,
IdentityMapper,
Closeable,
BusLifeCycleListener,
ManagedComponent {
    private static final Logger LOG = LogUtils.getL7dLogger(EHCacheIdentityCache.class);
    private IdentityMapper identityMapper;
    private MemoryIdentityCacheStatistics statistics;
    private Ehcache cache;
    private Bus bus;
    private CacheManager cacheManager;

    public EHCacheIdentityCache(IdentityMapper identityMapper, Bus b) {
        this(identityMapper, EHCacheIdentityCache.class.getName(), b, null);
    }

    public EHCacheIdentityCache(IdentityMapper identityMapper, String key, Bus b, URL configFileURL) {
        this.identityMapper = identityMapper;
        this.bus = b;
        if (this.bus != null) {
            ((BusLifeCycleManager)b.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this);
            InstrumentationManager im = (InstrumentationManager)b.getExtension(InstrumentationManager.class);
            if (im != null) {
                try {
                    im.register((ManagedComponent)this);
                }
                catch (JMException e) {
                    LOG.log(Level.WARNING, "Registering EHCacheIdentityCache failed.", e);
                }
            }
        }
        this.cacheManager = configFileURL != null ? EHCacheManagerHolder.getCacheManager((Bus)this.bus, (URL)configFileURL) : EHCacheManagerHolder.getCacheManager((Bus)this.bus, (URL)this.getDefaultConfigFileURL());
        CacheConfiguration cc = EHCacheManagerHolder.getCacheConfiguration((String)key, (CacheManager)this.cacheManager);
        Cache newCache = new Cache(cc);
        this.cache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
    }

    public MemoryIdentityCacheStatistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = new MemoryIdentityCacheStatistics(this.bus, this);
        }
        return this.statistics;
    }

    public void setStatistics(MemoryIdentityCacheStatistics stats) {
        this.statistics = stats;
    }

    @Override
    public void add(String user, String realm, Map<String, String> identities) {
        this.cache.put(new Element((Object)(user + "@" + realm), identities));
    }

    @Override
    @ManagedOperation
    public Map<String, String> get(String user, String realm) {
        Element element = this.cache.get((Serializable)((Object)(user + "@" + realm)));
        if (element != null && !this.cache.isExpired(element)) {
            return (Map)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void remove(String user, String realm) {
        this.cache.remove((Serializable)((Object)(user + "@" + realm)));
    }

    @Override
    @ManagedOperation
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    @ManagedOperation
    public int size() {
        return this.cache.getSize();
    }

    @ManagedOperation
    public String getContent() {
        return this.cache.toString();
    }

    @Override
    public Principal mapPrincipal(String sourceRealm, Principal sourcePrincipal, String targetRealm) {
        Principal targetPrincipal = null;
        Map<String, String> identities = this.get(sourcePrincipal.getName(), sourceRealm);
        if (identities != null) {
            String targetUser;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Identities found for '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
            }
            if ((targetUser = identities.get(targetRealm)) == null) {
                this.getStatistics().increaseCacheMiss();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No mapping found for realm " + targetRealm + " of user '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
                }
                targetPrincipal = this.identityMapper.mapPrincipal(sourceRealm, sourcePrincipal, targetRealm);
                identities.put(targetRealm, targetPrincipal.getName());
                Map<String, String> cachedItem = this.get(targetPrincipal.getName(), targetRealm);
                if (cachedItem != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Merging mappings for '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
                    }
                    this.mergeMap(identities, cachedItem);
                }
                this.add(targetPrincipal.getName(), targetRealm, identities);
            } else {
                this.getStatistics().increaseCacheHit();
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Mapping '" + sourcePrincipal.getName() + "@" + sourceRealm + "' to '" + targetUser + "@" + targetRealm + "' cached");
                }
                targetPrincipal = new CustomTokenPrincipal(targetUser);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No mapping found for realm " + targetRealm + " of user '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
            }
            this.getStatistics().increaseCacheMiss();
            targetPrincipal = this.identityMapper.mapPrincipal(sourceRealm, sourcePrincipal, targetRealm);
            identities = new HashMap<String, String>();
            identities.put(sourceRealm, sourcePrincipal.getName());
            identities.put(targetRealm, targetPrincipal.getName());
            this.add(targetPrincipal.getName(), targetRealm, identities);
            this.add(sourcePrincipal.getName(), sourceRealm, identities);
        }
        return targetPrincipal;
    }

    private void mergeMap(Map<String, String> to, Map<String, String> from) {
        for (String key : from.keySet()) {
            to.put(key, from.get(key));
        }
        for (String key : to.keySet()) {
            from.put(key, to.get(key));
        }
    }

    @Override
    public void close() {
        if (this.cacheManager != null) {
            EHCacheManagerHolder.releaseCacheManger((CacheManager)this.cacheManager);
            this.cacheManager = null;
            this.cache = null;
            if (this.bus != null) {
                ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
        this.close();
    }

    public void postShutdown() {
        this.close();
    }

    private URL getDefaultConfigFileURL() {
        URL url = null;
        ResourceManager rm = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        url = (URL)rm.resolveResource("sts-ehcache.xml", URL.class);
        try {
            if (url == null) {
                url = ClassLoaderUtils.getResource((String)"sts-ehcache.xml", TokenStoreFactory.class);
            }
            if (url == null) {
                url = new URL("sts-ehcache.xml");
            }
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ObjectName getObjectName() throws JMException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("org.apache.cxf").append(':');
        buffer.append("bus.id").append('=').append(this.bus.getId()).append(',');
        buffer.append("type").append('=').append("EHCacheIdentityCache").append(',');
        buffer.append("name").append('=').append("EHCacheIdentityCache-" + System.identityHashCode(this));
        return new ObjectName(buffer.toString());
    }
}

