/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.realm.CertConstraintsParser;
import org.apache.cxf.sts.token.realm.SAMLRealmCodec;
import org.apache.cxf.sts.token.validator.DefaultSAMLRoleParser;
import org.apache.cxf.sts.token.validator.SAMLRoleParser;
import org.apache.cxf.sts.token.validator.TokenValidator;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorResponse;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.ws.security.SAMLTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SignatureTrustValidator;
import org.apache.ws.security.validate.Validator;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;
import org.w3c.dom.Element;

public class SAMLTokenValidator
implements TokenValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLTokenValidator.class);
    private Validator validator = new SignatureTrustValidator();
    private CertConstraintsParser certConstraints = new CertConstraintsParser();
    private SAMLRealmCodec samlRealmCodec;
    private SAMLRoleParser samlRoleParser = new DefaultSAMLRoleParser();

    public void setSubjectConstraints(List<String> subjectConstraints) {
        this.certConstraints.setSubjectConstraints(subjectConstraints);
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setSamlRealmCodec(SAMLRealmCodec samlRealmCodec) {
        this.samlRealmCodec = samlRealmCodec;
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget) {
        return this.canHandleToken(validateTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken validateTarget, String realm) {
        Object token = validateTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(namespace)) && "Assertion".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public TokenValidatorResponse validateToken(TokenValidatorParameters tokenParameters) {
        LOG.fine("Validating SAML Token");
        STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
        Crypto sigCrypto = stsProperties.getSignatureCrypto();
        CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
        TokenValidatorResponse response = new TokenValidatorResponse();
        ReceivedToken validateTarget = tokenParameters.getToken();
        validateTarget.setState(ReceivedToken.STATE.INVALID);
        response.setToken(validateTarget);
        if (!validateTarget.isDOMElement()) {
            return response;
        }
        try {
            Element validateTargetElement = (Element)validateTarget.getToken();
            AssertionWrapper assertion = new AssertionWrapper(validateTargetElement);
            SAMLTokenPrincipal samlPrincipal = new SAMLTokenPrincipal(assertion);
            response.setPrincipal((Principal)samlPrincipal);
            if (!assertion.isSigned()) {
                LOG.log(Level.WARNING, "The received assertion is not signed, and therefore not trusted");
                return response;
            }
            RequestData requestData = new RequestData();
            requestData.setSigCrypto(sigCrypto);
            WSSConfig wssConfig = WSSConfig.getNewInstance();
            requestData.setWssConfig(wssConfig);
            requestData.setCallbackHandler(callbackHandler);
            requestData.setMsgContext((Object)tokenParameters.getWebServiceContext().getMessageContext());
            assertion.verifySignature(requestData, new WSDocInfo(validateTargetElement.getOwnerDocument()));
            SecurityToken secToken = null;
            byte[] signatureValue = assertion.getSignatureValue();
            if (tokenParameters.getTokenStore() != null && signatureValue != null && signatureValue.length > 0) {
                int hash = Arrays.hashCode(signatureValue);
                secToken = tokenParameters.getTokenStore().getToken(Integer.toString(hash));
                if (secToken != null && secToken.getTokenHash() != hash) {
                    secToken = null;
                }
            }
            if (secToken != null && secToken.isExpired()) {
                LOG.fine("Token: " + secToken.getId() + " is in the cache but expired - revalidating");
                secToken = null;
            }
            if (secToken == null) {
                this.validateAssertion(assertion);
                Credential trustCredential = new Credential();
                SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
                trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
                trustCredential.setCertificates(samlKeyInfo.getCerts());
                trustCredential = this.validator.validate(trustCredential, requestData);
                X509Certificate cert = null;
                if (trustCredential.getCertificates() != null) {
                    cert = trustCredential.getCertificates()[0];
                }
                if (!this.certConstraints.matches(cert)) {
                    return response;
                }
            }
            if (this.samlRoleParser != null) {
                Set<Principal> roles = this.samlRoleParser.parseRolesFromAssertion((Principal)samlPrincipal, null, assertion);
                response.setRoles(roles);
            }
            String tokenRealm = null;
            if (this.samlRealmCodec != null) {
                String cachedRealm;
                Properties props;
                tokenRealm = this.samlRealmCodec.getRealmFromToken(assertion);
                if (secToken != null && (props = secToken.getProperties()) != null && (cachedRealm = props.getProperty("org.apache.cxf.sts.token.realm")) != null && !tokenRealm.equals(cachedRealm)) {
                    return response;
                }
            }
            response.setTokenRealm(tokenRealm);
            if (!this.validateConditions(assertion, validateTarget)) {
                return response;
            }
            if (secToken == null) {
                this.storeTokenInCache(tokenParameters.getTokenStore(), assertion, tokenParameters.getPrincipal(), tokenRealm);
            }
            HashMap<String, Object> addProps = new HashMap<String, Object>();
            addProps.put(AssertionWrapper.class.getName(), assertion);
            response.setAdditionalProperties(addProps);
            validateTarget.setState(ReceivedToken.STATE.VALID);
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        return response;
    }

    protected void validateAssertion(AssertionWrapper assertion) throws WSSecurityException {
        if (assertion.getSaml1() != null) {
            ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml1-schema-validator");
            ValidatorSuite specValidators = Configuration.getValidatorSuite((String)"saml1-spec-validator");
            try {
                schemaValidators.validate((XMLObject)assertion.getSaml1());
                specValidators.validate((XMLObject)assertion.getSaml1());
            }
            catch (ValidationException e) {
                LOG.fine("Saml Validation error: " + e.getMessage());
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        if (assertion.getSaml2() != null) {
            ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml2-core-schema-validator");
            ValidatorSuite specValidators = Configuration.getValidatorSuite((String)"saml2-core-spec-validator");
            try {
                schemaValidators.validate((XMLObject)assertion.getSaml2());
                specValidators.validate((XMLObject)assertion.getSaml2());
            }
            catch (ValidationException e) {
                LOG.fine("Saml Validation error: " + e.getMessage());
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
    }

    protected boolean validateConditions(AssertionWrapper assertion, ReceivedToken validateTarget) {
        DateTime validFrom = null;
        DateTime validTill = null;
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
            validFrom = assertion.getSaml2().getConditions().getNotBefore();
            validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
        } else {
            validFrom = assertion.getSaml1().getConditions().getNotBefore();
            validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
        }
        if (validFrom.isAfterNow()) {
            LOG.log(Level.WARNING, "SAML Token condition not met");
            return false;
        }
        if (validTill.isBeforeNow()) {
            LOG.log(Level.WARNING, "SAML Token condition not met");
            validateTarget.setState(ReceivedToken.STATE.EXPIRED);
            return false;
        }
        return true;
    }

    private void storeTokenInCache(TokenStore tokenStore, AssertionWrapper assertion, Principal principal, String tokenRealm) throws WSSecurityException {
        byte[] signatureValue = assertion.getSignatureValue();
        if (tokenStore != null && signatureValue != null && signatureValue.length > 0) {
            DateTime validTill = null;
            validTill = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? assertion.getSaml2().getConditions().getNotOnOrAfter() : assertion.getSaml1().getConditions().getNotOnOrAfter();
            SecurityToken securityToken = new SecurityToken(assertion.getId(), null, validTill.toDate());
            securityToken.setToken(assertion.getElement());
            securityToken.setPrincipal(principal);
            if (tokenRealm != null) {
                Properties props = new Properties();
                props.setProperty("org.apache.cxf.sts.token.realm", tokenRealm);
                securityToken.setProperties(props);
            }
            int hash = Arrays.hashCode(signatureValue);
            securityToken.setTokenHash(hash);
            String identifier = Integer.toString(hash);
            tokenStore.add(identifier, securityToken);
        }
    }

    public SAMLRoleParser getSamlRoleParser() {
        return this.samlRoleParser;
    }

    public void setSamlRoleParser(SAMLRoleParser samlRoleParser) {
        this.samlRoleParser = samlRoleParser;
    }
}

