/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;

public class Claim
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1151700035195497499L;
    private URI claimType;
    private String issuer;
    private String originalIssuer;
    private transient Principal principal;
    private List<String> values = new ArrayList<String>(1);

    public Claim() {
    }

    public Claim(Claim claim) {
        if (claim == null) {
            throw new IllegalArgumentException("Claim cannot be null");
        }
        if (claim.claimType != null) {
            this.claimType = URI.create(claim.claimType.toString());
        }
        this.issuer = claim.issuer;
        this.originalIssuer = claim.originalIssuer;
        this.values.addAll(claim.values);
        this.principal = claim.principal;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getOriginalIssuer() {
        return this.originalIssuer;
    }

    public void setOriginalIssuer(String originalIssuer) {
        this.originalIssuer = originalIssuer;
    }

    public URI getClaimType() {
        return this.claimType;
    }

    public void setClaimType(URI claimType) {
        this.claimType = claimType;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public void setValues(List<String> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void addValue(String s) {
        this.values.add(s);
    }

    public List<String> getValues() {
        return this.values;
    }

    @Deprecated
    public void setValue(String value) {
        this.values.clear();
        if (value != null) {
            this.values.add(value);
        }
    }

    @Deprecated
    public String getValue() {
        if (this.values.size() == 0) {
            return null;
        }
        if (this.values.size() == 1) {
            return this.values.get(0);
        }
        throw new IllegalStateException("Claim has multiple values");
    }

    public Claim clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new Claim(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.claimType == null ? 0 : this.claimType.hashCode());
        result = 31 * result + (this.issuer == null ? 0 : this.issuer.hashCode());
        result = 31 * result + (this.originalIssuer == null ? 0 : this.originalIssuer.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Claim)) {
            return false;
        }
        Claim other = (Claim)obj;
        if (this.claimType == null ? other.claimType != null : !this.claimType.equals(other.claimType)) {
            return false;
        }
        if (this.issuer == null ? other.issuer != null : !this.issuer.equals(other.issuer)) {
            return false;
        }
        if (this.originalIssuer == null ? other.originalIssuer != null : !this.originalIssuer.equals(other.originalIssuer)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Claim [values=");
        builder.append(this.values);
        builder.append(", claimType=");
        builder.append(this.claimType);
        builder.append(", issuer=");
        builder.append(this.issuer);
        builder.append(", originalIssuer=");
        builder.append(this.originalIssuer);
        builder.append(", principal=");
        builder.append(this.principal);
        builder.append("]");
        return builder.toString();
    }
}

