/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.cache;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.annotation.ManagedOperation;
import org.apache.cxf.management.annotation.ManagedResource;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.cache.IdentityCache;
import org.apache.cxf.sts.cache.MemoryIdentityCacheStatistics;
import org.apache.ws.security.CustomTokenPrincipal;

@ManagedResource
public class MemoryIdentityCache
implements IdentityCache,
IdentityMapper,
ManagedComponent {
    private static final Logger LOG = LogUtils.getL7dLogger(MemoryIdentityCache.class);
    private final Map<String, Map<String, String>> cache = Collections.synchronizedMap(new HashMap());
    private long maxCacheItems = 10000L;
    private IdentityMapper identityMapper;
    private final Bus bus;
    private MemoryIdentityCacheStatistics statistics;

    protected MemoryIdentityCache() {
        this.bus = null;
    }

    public MemoryIdentityCache(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
        this.bus = null;
    }

    public MemoryIdentityCache(Bus bus, IdentityMapper identityMapper) {
        InstrumentationManager im;
        this.identityMapper = identityMapper;
        this.bus = bus;
        if (bus != null && (im = (InstrumentationManager)bus.getExtension(InstrumentationManager.class)) != null) {
            try {
                im.register((ManagedComponent)this);
            }
            catch (JMException e) {
                LOG.log(Level.WARNING, "Registering MemoryIdentityCache failed.", e);
            }
        }
    }

    public MemoryIdentityCacheStatistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = new MemoryIdentityCacheStatistics(this.bus, this);
        }
        return this.statistics;
    }

    public void setStatistics(MemoryIdentityCacheStatistics stats) {
        this.statistics = stats;
    }

    public long getMaxCacheItems() {
        return this.maxCacheItems;
    }

    public void setMaxCacheItems(long maxCacheItems) {
        this.maxCacheItems = maxCacheItems;
    }

    @Override
    public void add(String user, String realm, Map<String, String> identities) {
        if ((long)this.cache.size() >= this.maxCacheItems) {
            this.cache.clear();
        }
        this.cache.put(user + "@" + realm, identities);
    }

    @Override
    @ManagedOperation
    public Map<String, String> get(String user, String realm) {
        return this.cache.get(user + "@" + realm);
    }

    @Override
    public void remove(String user, String realm) {
        this.cache.remove(user + "@" + realm);
    }

    @Override
    @ManagedOperation
    public void clear() {
        this.cache.clear();
    }

    @Override
    @ManagedOperation
    public int size() {
        return this.cache.size();
    }

    @ManagedOperation
    public String getContent() {
        return this.cache.toString();
    }

    @Override
    public Principal mapPrincipal(String sourceRealm, Principal sourcePrincipal, String targetRealm) {
        Principal targetPrincipal = null;
        Map<String, String> identities = this.get(sourcePrincipal.getName(), sourceRealm);
        if (identities != null) {
            String targetUser;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Identities found for '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
            }
            if ((targetUser = identities.get(targetRealm)) == null) {
                this.getStatistics().increaseCacheMiss();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No mapping found for realm " + targetRealm + " of user '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
                }
                if ((targetPrincipal = this.identityMapper.mapPrincipal(sourceRealm, sourcePrincipal, targetRealm)) == null || targetPrincipal.getName() == null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Failed to map user '" + sourcePrincipal.getName() + "' [" + sourceRealm + "] to realm '" + targetRealm + "'");
                    }
                    return null;
                }
                identities.put(targetRealm, targetPrincipal.getName());
                Map<String, String> cachedItem = this.get(targetPrincipal.getName(), targetRealm);
                if (cachedItem != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Merging mappings for '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
                    }
                    this.mergeMap(identities, cachedItem);
                }
                this.add(targetPrincipal.getName(), targetRealm, identities);
            } else {
                this.getStatistics().increaseCacheHit();
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Mapping '" + sourcePrincipal.getName() + "@" + sourceRealm + "' to '" + targetUser + "@" + targetRealm + "' cached");
                }
                targetPrincipal = new CustomTokenPrincipal(targetUser);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No mapping found for realm " + targetRealm + " of user '" + sourcePrincipal.getName() + "@" + sourceRealm + "'");
            }
            this.getStatistics().increaseCacheMiss();
            targetPrincipal = this.identityMapper.mapPrincipal(sourceRealm, sourcePrincipal, targetRealm);
            identities = new HashMap<String, String>();
            identities.put(sourceRealm, sourcePrincipal.getName());
            identities.put(targetRealm, targetPrincipal.getName());
            this.add(targetPrincipal.getName(), targetRealm, identities);
            this.add(sourcePrincipal.getName(), sourceRealm, identities);
        }
        return targetPrincipal;
    }

    private void mergeMap(Map<String, String> to, Map<String, String> from) {
        for (String key : from.keySet()) {
            to.put(key, from.get(key));
        }
        for (String key : to.keySet()) {
            from.put(key, to.get(key));
        }
    }

    public ObjectName getObjectName() throws JMException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("org.apache.cxf").append(':');
        buffer.append("bus.id").append('=').append(this.bus.getId()).append(',');
        buffer.append("type").append('=').append("MemoryIdentityCache").append(',');
        buffer.append("name").append('=').append("MemoryIdentityCache-" + System.identityHashCode(this));
        return new ObjectName(buffer.toString());
    }
}

