/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.event.map;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.event.map.KEYS;
import org.apache.cxf.sts.event.map.MapEvent;
import org.apache.cxf.sts.event.map.MapEventListener;

public class MapEventLogger
implements MapEventListener {
    private static final Logger LOG = LogUtils.getL7dLogger(MapEventLogger.class);
    private List<String> fieldOrder = new ArrayList<String>();
    private boolean logStacktrace;
    private boolean logFieldname;
    private Level logLevel = Level.FINE;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);

    public MapEventLogger() {
        this.fieldOrder.add(KEYS.TIME.name());
        this.fieldOrder.add(KEYS.STATUS.name());
        this.fieldOrder.add(KEYS.DURATION.name());
        this.fieldOrder.add(KEYS.REMOTE_HOST.name());
        this.fieldOrder.add(KEYS.REMOTE_PORT.name());
        this.fieldOrder.add(KEYS.OPERATION.name());
        this.fieldOrder.add(KEYS.URL.name());
        this.fieldOrder.add(KEYS.REALM.name());
        this.fieldOrder.add(KEYS.WS_SEC_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.ONBEHALFOF_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.ACTAS_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.VALIDATE_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.CANCEL_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.RENEW_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.TOKENTYPE.name());
        this.fieldOrder.add(KEYS.APPLIESTO.name());
        this.fieldOrder.add(KEYS.CLAIMS_PRIMARY.name());
        this.fieldOrder.add(KEYS.CLAIMS_SECONDARY.name());
        this.fieldOrder.add(KEYS.EXCEPTION.name());
        this.fieldOrder.add(KEYS.STACKTRACE.name());
    }

    @Override
    public void onEvent(MapEvent event) {
        Map<String, ?> map = event.getProperties();
        StringBuilder builder = new StringBuilder();
        for (String key : this.fieldOrder) {
            if (this.logFieldname) {
                builder.append(key).append("=").append(map.get(key)).append(";");
                continue;
            }
            builder.append(this.format(map.get(key))).append(";");
        }
        Exception ex = (Exception)map.get(KEYS.EXCEPTION.name());
        LOG.log(this.logLevel, builder.toString(), ex);
    }

    private String format(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return this.dateFormat.format(value);
        }
        return value.toString();
    }

    public List<String> getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(List<String> fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    public boolean isLogStacktrace() {
        return this.logStacktrace;
    }

    public void setLogStacktrace(boolean logStacktrace) {
        this.logStacktrace = logStacktrace;
    }

    public boolean isLogFieldname() {
        return this.logFieldname;
    }

    public void setLogFieldname(boolean logFieldname) {
        this.logFieldname = logFieldname;
    }

    public void setDateFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }

    public String getLogLevel() {
        return this.logLevel.getName();
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = Level.parse(logLevel);
    }
}

