/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.saml.SAMLSecurityContext;
import org.apache.cxf.rt.security.saml.SAMLUtils;
import org.apache.cxf.sts.token.validator.SAMLRoleParser;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;

public class DefaultSAMLRoleParser
implements SAMLRoleParser {
    public static final String SAML_ROLE_ATTRIBUTENAME_DEFAULT = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
    private boolean useJaasSubject = true;
    private String roleClassifier;
    private String roleClassifierType = "prefix";
    private String roleAttributeName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";

    @Override
    public Set<Principal> parseRolesFromAssertion(Principal principal, Subject subject, SamlAssertionWrapper assertion) {
        if (subject != null && this.useJaasSubject) {
            if (this.roleClassifier != null && !"".equals(this.roleClassifier)) {
                RolePrefixSecurityContextImpl securityContext = new RolePrefixSecurityContextImpl(subject, this.roleClassifier, this.roleClassifierType);
                return securityContext.getUserRoles();
            }
            return new DefaultSecurityContext(principal, subject).getUserRoles();
        }
        ClaimCollection claims = SAMLUtils.getClaims((SamlAssertionWrapper)assertion);
        Set roles = SAMLUtils.parseRolesFromClaims((ClaimCollection)claims, (String)this.roleAttributeName, null);
        SAMLSecurityContext context = new SAMLSecurityContext(principal, roles, claims);
        return context.getUserRoles();
    }

    public boolean isUseJaasSubject() {
        return this.useJaasSubject;
    }

    public void setUseJaasSubject(boolean useJaasSubject) {
        this.useJaasSubject = useJaasSubject;
    }

    public String getRoleClassifier() {
        return this.roleClassifier;
    }

    public void setRoleClassifier(String roleClassifier) {
        this.roleClassifier = roleClassifier;
    }

    public String getRoleClassifierType() {
        return this.roleClassifierType;
    }

    public void setRoleClassifierType(String roleClassifierType) {
        this.roleClassifierType = roleClassifierType;
    }

    public String getRoleAttributeName() {
        return this.roleAttributeName;
    }

    public void setRoleAttributeName(String roleAttributeName) {
        this.roleAttributeName = roleAttributeName;
    }
}

