/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.DefaultAttributeStatementProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AuthDecisionStatementBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.opensaml.common.SAMLVersion;

public class SamlCallbackHandler
implements CallbackHandler {
    private TokenProviderParameters tokenParameters;
    private List<AttributeStatementBean> attributeBeans;
    private List<AuthenticationStatementBean> authBeans;
    private List<AuthDecisionStatementBean> authDecisionBeans;
    private ConditionsBean conditionsBean;
    private SubjectBean subjectBean;
    private String issuer;

    public void setAttributeBeans(List<AttributeStatementBean> attributeBeanList) {
        this.attributeBeans = attributeBeanList;
    }

    public void setAuthenticationBeans(List<AuthenticationStatementBean> authBeanList) {
        this.authBeans = authBeanList;
    }

    public void setAuthDecisionStatementBeans(List<AuthDecisionStatementBean> authDecisionBeanList) {
        this.authDecisionBeans = authDecisionBeanList;
    }

    public void setSubjectBean(SubjectBean subjectBean) {
        this.subjectBean = subjectBean;
    }

    public void setConditionsBean(ConditionsBean conditionsBean) {
        this.conditionsBean = conditionsBean;
    }

    public void setTokenProviderParameters(TokenProviderParameters tokenProviderParameters) {
        this.tokenParameters = tokenProviderParameters;
    }

    public void setIssuer(String issuerName) {
        this.issuer = issuerName;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof SAMLCallback)) continue;
            SAMLCallback callback = (SAMLCallback)callbacks[i];
            if (this.subjectBean != null) {
                callback.setSubject(this.subjectBean);
            }
            TokenRequirements tokenRequirements = this.tokenParameters.getTokenRequirements();
            String tokenType = tokenRequirements.getTokenType();
            boolean saml1 = false;
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                callback.setSamlVersion(SAMLVersion.VERSION_20);
            } else {
                callback.setSamlVersion(SAMLVersion.VERSION_11);
                saml1 = true;
                this.setSubjectOnBeans();
            }
            if (this.issuer == null) {
                STSPropertiesMBean stsProperties = this.tokenParameters.getStsProperties();
                callback.setIssuer(stsProperties.getIssuer());
            } else {
                callback.setIssuer(this.issuer);
            }
            boolean statementAdded = false;
            if (this.attributeBeans != null && !this.attributeBeans.isEmpty()) {
                callback.setAttributeStatementData(this.attributeBeans);
                statementAdded = true;
            }
            if (this.authBeans != null && !this.authBeans.isEmpty()) {
                callback.setAuthenticationStatementData(this.authBeans);
                statementAdded = true;
            }
            if (this.authDecisionBeans != null && !this.authDecisionBeans.isEmpty()) {
                callback.setAuthDecisionStatementData(this.authDecisionBeans);
                statementAdded = true;
            }
            if (saml1 && !statementAdded) {
                AttributeStatementBean defaultStatement = new DefaultAttributeStatementProvider().getStatement(this.tokenParameters);
                defaultStatement.setSubject(this.subjectBean);
                callback.setAttributeStatementData(Collections.singletonList(defaultStatement));
            }
            callback.setConditions(this.conditionsBean);
        }
    }

    private void setSubjectOnBeans() {
        if (this.attributeBeans != null) {
            for (AttributeStatementBean attributeBean : this.attributeBeans) {
                if (attributeBean.getSubject() != null) continue;
                attributeBean.setSubject(this.subjectBean);
            }
        }
        if (this.authBeans != null) {
            for (AuthenticationStatementBean authBean : this.authBeans) {
                if (authBean.getSubject() != null) continue;
                authBean.setSubject(this.subjectBean);
            }
        }
        if (this.authDecisionBeans != null) {
            for (AuthDecisionStatementBean authDecisionBean : this.authDecisionBeans) {
                if (authDecisionBean.getSubject() != null) continue;
                authDecisionBean.setSubject(this.subjectBean);
            }
        }
    }
}

