/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.canceller;

import java.security.Key;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.canceller.TokenCanceller;
import org.apache.cxf.sts.token.canceller.TokenCancellerParameters;
import org.apache.cxf.sts.token.canceller.TokenCancellerResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.AbstractSecuredElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.w3c.dom.Element;

public class SCTCanceller
implements TokenCanceller {
    private static final Logger LOG = LogUtils.getL7dLogger(SCTCanceller.class);
    private boolean verifyProofOfPossession = true;

    @Override
    public boolean canHandleToken(ReceivedToken targetToken) {
        Object token = targetToken.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("http://schemas.xmlsoap.org/ws/2005/02/sc".equals(namespace) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512".equals(namespace)) && "SecurityContextToken".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public TokenCancellerResponse cancelToken(TokenCancellerParameters tokenParameters) {
        LOG.fine("Trying to cancel a SecurityContextToken");
        TokenCancellerResponse response = new TokenCancellerResponse();
        ReceivedToken cancelTarget = tokenParameters.getToken();
        if (tokenParameters.getTokenStore() == null) {
            LOG.log(Level.FINE, "A cache must be configured to use the SCTCanceller");
            return response;
        }
        if (cancelTarget == null) {
            LOG.log(Level.FINE, "Cancel Target is null");
            return response;
        }
        cancelTarget.setState(ReceivedToken.STATE.NONE);
        response.setToken(cancelTarget);
        if (cancelTarget.isDOMElement()) {
            try {
                Element cancelTargetElement = (Element)cancelTarget.getToken();
                SecurityContextToken sct = new SecurityContextToken(cancelTargetElement);
                String identifier = sct.getIdentifier();
                SecurityToken token = tokenParameters.getTokenStore().getToken(identifier);
                if (token == null) {
                    LOG.fine("Identifier: " + identifier + " is not found in the cache");
                    return response;
                }
                if (this.verifyProofOfPossession && !this.matchKey(tokenParameters, token.getSecret())) {
                    throw new STSException("Failed to verify the proof of possession of the key associated with the security context. No matching key found in the request.", STSException.INVALID_REQUEST);
                }
                tokenParameters.getTokenStore().remove(token.getId());
                cancelTarget.setState(ReceivedToken.STATE.CANCELLED);
                LOG.fine("SecurityContextToken successfully cancelled");
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
            }
        }
        return response;
    }

    private boolean matchKey(TokenCancellerParameters tokenParameters, byte[] secretKey) {
        MessageContext messageContext = tokenParameters.getWebServiceContext().getMessageContext();
        if (this.matchDOMSignatureSecret(messageContext, secretKey)) {
            return true;
        }
        try {
            if (this.matchStreamingSignatureSecret(messageContext, secretKey)) {
                return true;
            }
        }
        catch (XMLSecurityException ex) {
            LOG.log(Level.FINE, ex.getMessage(), ex);
            return false;
        }
        return false;
    }

    @Override
    public void setVerifyProofOfPossession(boolean verifyProofOfPossession) {
        this.verifyProofOfPossession = verifyProofOfPossession;
    }

    private boolean matchDOMSignatureSecret(MessageContext messageContext, byte[] secretToMatch) {
        WSHandlerResult handlerResult;
        List signedResults;
        List handlerResults = CastUtils.cast((List)((List)messageContext.get((Object)"RECV_RESULTS")));
        if (handlerResults != null && handlerResults.size() > 0 && (signedResults = (List)(handlerResult = (WSHandlerResult)handlerResults.get(0)).getActionResults().get(2)) != null) {
            for (WSSecurityEngineResult engineResult : signedResults) {
                byte[] receivedKey = (byte[])engineResult.get((Object)"secret");
                if (!Arrays.equals(secretToMatch, receivedKey)) continue;
                LOG.log(Level.FINE, "Verification of the proof of possession of the key associated with the security context successful.");
                return true;
            }
        }
        return false;
    }

    private boolean matchStreamingSignatureSecret(MessageContext messageContext, byte[] secretToMatch) throws XMLSecurityException {
        List incomingEventList = (List)messageContext.get((Object)(SecurityEvent.class.getName() + ".in"));
        if (incomingEventList != null) {
            for (SecurityEvent incomingEvent : incomingEventList) {
                org.apache.xml.security.stax.securityToken.SecurityToken token;
                if (WSSecurityEventConstants.SignedPart != incomingEvent.getSecurityEventType() && WSSecurityEventConstants.SignedElement != incomingEvent.getSecurityEventType() || (token = ((AbstractSecuredElementSecurityEvent)incomingEvent).getSecurityToken()) == null || token.getSecretKey() == null) continue;
                for (String key : token.getSecretKey().keySet()) {
                    Key keyObject = (Key)token.getSecretKey().get(key);
                    if (!(keyObject instanceof SecretKey) || !Arrays.equals(secretToMatch, ((SecretKey)keyObject).getEncoded())) continue;
                    LOG.log(Level.FINE, "Verification of the proof of possession of the key associated with the security context successful.");
                    return true;
                }
            }
        }
        return false;
    }
}

