/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.delegation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.delegation.TokenDelegationHandler;
import org.apache.cxf.sts.token.delegation.TokenDelegationParameters;
import org.apache.cxf.sts.token.delegation.TokenDelegationResponse;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.w3c.dom.Element;

public class SAMLDelegationHandler
implements TokenDelegationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLDelegationHandler.class);
    private boolean checkAudienceRestriction;

    @Override
    public boolean canHandleToken(ReceivedToken delegateTarget) {
        Object token = delegateTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(namespace)) && "Assertion".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public TokenDelegationResponse isDelegationAllowed(TokenDelegationParameters tokenParameters) {
        TokenDelegationResponse response = new TokenDelegationResponse();
        ReceivedToken delegateTarget = tokenParameters.getToken();
        response.setToken(delegateTarget);
        if (delegateTarget.getState() != ReceivedToken.STATE.VALID || !delegateTarget.isDOMElement()) {
            LOG.fine("Delegation token is not valid");
            return response;
        }
        if (this.isDelegationAllowed(delegateTarget, tokenParameters.getAppliesToAddress())) {
            LOG.fine("Delegation is allowed for principal " + tokenParameters.getPrincipal());
            response.setDelegationAllowed(true);
        } else {
            LOG.fine("Delegation is not allowed for principal " + tokenParameters.getPrincipal());
        }
        return response;
    }

    protected boolean isDelegationAllowed(ReceivedToken receivedToken, String appliesToAddress) {
        Element validateTargetElement = (Element)receivedToken.getToken();
        try {
            List<String> addresses;
            SamlAssertionWrapper assertion = new SamlAssertionWrapper(validateTargetElement);
            for (String confirmationMethod : assertion.getConfirmationMethods()) {
                if ("urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(confirmationMethod) || "urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmationMethod)) continue;
                LOG.fine("An unsupported Confirmation Method was used: " + confirmationMethod);
                return false;
            }
            if (this.checkAudienceRestriction && appliesToAddress != null && !(addresses = this.getAudienceRestrictions(assertion)).isEmpty() && !addresses.contains(appliesToAddress)) {
                LOG.fine("The AppliesTo address " + appliesToAddress + " is not contained" + " in the Audience Restriction addresses in the assertion");
                return false;
            }
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.WARNING, "Error in ascertaining whether delegation is allowed", ex);
            return false;
        }
        return true;
    }

    protected List<String> getAudienceRestrictions(SamlAssertionWrapper assertion) {
        ArrayList<String> addresses;
        block5: {
            block4: {
                addresses = new ArrayList<String>();
                if (assertion.getSaml1() == null) break block4;
                for (AudienceRestrictionCondition restriction : assertion.getSaml1().getConditions().getAudienceRestrictionConditions()) {
                    for (org.opensaml.saml.saml1.core.Audience audience : restriction.getAudiences()) {
                        addresses.add(audience.getUri());
                    }
                }
                break block5;
            }
            if (assertion.getSaml2() == null) break block5;
            for (AudienceRestriction restriction : assertion.getSaml2().getConditions().getAudienceRestrictions()) {
                for (Audience audience : restriction.getAudiences()) {
                    addresses.add(audience.getAudienceURI());
                }
            }
        }
        return addresses;
    }

    public boolean isCheckAudienceRestriction() {
        return this.checkAudienceRestriction;
    }

    public void setCheckAudienceRestriction(boolean checkAudienceRestriction) {
        this.checkAudienceRestriction = checkAudienceRestriction;
    }
}

