/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.AbstractSecuredElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityToken;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public final class TokenProviderUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenProviderUtils.class);

    private TokenProviderUtils() {
    }

    public static String extractAddressFromParticipantsEPR(Object participants) {
        if (participants instanceof Element) {
            String localName = ((Element)participants).getLocalName();
            String namespace = ((Element)participants).getNamespaceURI();
            if ("http://www.w3.org/2005/08/addressing".equals(namespace) && "EndpointReference".equals(localName)) {
                LOG.fine("Found EndpointReference element");
                Element address = DOMUtils.getFirstChildWithName((Element)((Element)participants), (String)"http://www.w3.org/2005/08/addressing", (String)"Address");
                if (address != null) {
                    LOG.fine("Found address element");
                    return address.getTextContent();
                }
            } else if (("http://www.w3.org/ns/ws-policy".equals(namespace) || "http://schemas.xmlsoap.org/ws/2004/09/policy".equals(namespace) || "http://www.w3.org/2006/07/ws-policy".equals(namespace)) && "URI".equals(localName)) {
                return ((Element)participants).getTextContent();
            }
            LOG.fine("Participants element does not exist or could not be parsed");
            return null;
        }
        if (participants instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)participants;
            QName participantsName = jaxbElement.getName();
            if ("http://www.w3.org/2005/08/addressing".equals(participantsName.getNamespaceURI()) && "EndpointReference".equals(participantsName.getLocalPart())) {
                LOG.fine("Found EndpointReference element");
                EndpointReferenceType endpointReference = (EndpointReferenceType)jaxbElement.getValue();
                if (endpointReference.getAddress() != null) {
                    LOG.fine("Found address element");
                    return endpointReference.getAddress().getValue();
                }
            }
            LOG.fine("Participants element does not exist or could not be parsed");
        }
        return null;
    }

    public static Element encryptToken(Element element, String id, STSPropertiesMBean stsProperties, EncryptionProperties encryptionProperties, KeyRequirements keyRequirements, Map<String, Object> messageContext) throws WSSecurityException {
        String name = encryptionProperties.getEncryptionName();
        if (name == null) {
            name = stsProperties.getEncryptionUsername();
        }
        if (name == null) {
            LOG.fine("No encryption alias is configured");
            return element;
        }
        String encryptionAlgorithm = keyRequirements.getEncryptionAlgorithm();
        if (encryptionAlgorithm == null) {
            encryptionAlgorithm = encryptionProperties.getEncryptionAlgorithm();
        } else {
            List<String> supportedAlgorithms = encryptionProperties.getAcceptedEncryptionAlgorithms();
            if (!supportedAlgorithms.contains(encryptionAlgorithm)) {
                encryptionAlgorithm = encryptionProperties.getEncryptionAlgorithm();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("EncryptionAlgorithm not supported, defaulting to: " + encryptionAlgorithm);
                }
            }
        }
        String keyWrapAlgorithm = keyRequirements.getKeywrapAlgorithm();
        if (keyWrapAlgorithm == null) {
            keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
        } else {
            List<String> supportedAlgorithms = encryptionProperties.getAcceptedKeyWrapAlgorithms();
            if (!supportedAlgorithms.contains(keyWrapAlgorithm)) {
                keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("KeyWrapAlgorithm not supported, defaulting to: " + keyWrapAlgorithm);
                }
            }
        }
        Document doc = element.getOwnerDocument();
        DocumentFragment frag = doc.createDocumentFragment();
        frag.appendChild(element);
        WSSecEncrypt builder = new WSSecEncrypt(doc);
        if ("useReqSigCert".equals(name)) {
            X509Certificate cert = TokenProviderUtils.getReqSigCert(messageContext);
            builder.setUseThisCert(cert);
        } else {
            builder.setUserInfo(name);
        }
        builder.setKeyIdentifierType(encryptionProperties.getKeyIdentifierType());
        builder.setSymmetricEncAlgorithm(encryptionAlgorithm);
        builder.setKeyEncAlgo(keyWrapAlgorithm);
        builder.setEmbedEncryptedKey(true);
        WSEncryptionPart encryptionPart = new WSEncryptionPart(id, "Element");
        encryptionPart.setElement(element);
        builder.prepare(stsProperties.getEncryptionCrypto());
        builder.encryptForRef(null, Collections.singletonList(encryptionPart));
        return (Element)frag.getFirstChild();
    }

    public static X509Certificate getReqSigCert(Map<String, Object> messageContext) {
        List results = (List)messageContext.get("RECV_RESULTS");
        X509Certificate cert = WSS4JUtils.getReqSigCert((List)results);
        if (cert != null) {
            return cert;
        }
        List incomingEventList = (List)messageContext.get(SecurityEvent.class.getName() + ".in");
        if (incomingEventList != null) {
            for (SecurityEvent incomingEvent : incomingEventList) {
                if (WSSecurityEventConstants.SIGNED_PART != incomingEvent.getSecurityEventType() && WSSecurityEventConstants.SignedElement != incomingEvent.getSecurityEventType()) continue;
                SecurityToken token = ((AbstractSecuredElementSecurityEvent)incomingEvent).getSecurityToken();
                try {
                    if (token == null || token.getX509Certificates() == null || token.getX509Certificates().length <= 0) continue;
                    return token.getX509Certificates()[0];
                }
                catch (XMLSecurityException ex) {
                    LOG.log(Level.FINE, ex.getMessage(), ex);
                    return null;
                }
            }
        }
        return null;
    }
}

