/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.crypto.provider;

import java.util.Properties;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.xkms.crypto.CryptoProviderException;
import org.apache.cxf.xkms.crypto.CryptoProviderFactory;
import org.apache.cxf.xkms.crypto.provider.CryptoProviderUtils;
import org.apache.cxf.xkms.crypto.provider.XkmsCryptoProvider;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.w3._2002._03.xkms_wsdl.XKMSPortType;

public class XkmsCryptoProviderFactory
implements CryptoProviderFactory {
    private final XKMSPortType xkmsConsumer;

    public XkmsCryptoProviderFactory(XKMSPortType xkmsConsumer) {
        this.xkmsConsumer = xkmsConsumer;
    }

    public Crypto create(Message message) {
        Object crypto = SecurityUtils.getSecurityPropertyValue((String)"security.signature.crypto", (Message)message);
        if (crypto instanceof Crypto) {
            new XkmsCryptoProvider(this.xkmsConsumer, (Crypto)crypto);
        }
        Properties keystoreProps = CryptoProviderUtils.loadKeystoreProperties(message, "security.signature.properties");
        try {
            Crypto defaultCrypto = CryptoFactory.getInstance((Properties)keystoreProps);
            return new XkmsCryptoProvider(this.xkmsConsumer, defaultCrypto);
        }
        catch (WSSecurityException e) {
            throw new CryptoProviderException("Cannot instantiate crypto factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public Crypto create() {
        return new XkmsCryptoProvider(this.xkmsConsumer);
    }

    public Crypto create(Crypto fallbackCrypto) {
        return new XkmsCryptoProvider(this.xkmsConsumer, fallbackCrypto);
    }

    public Crypto create(XKMSPortType xkmsClient, Crypto fallbackCrypto) {
        return new XkmsCryptoProvider(xkmsClient, fallbackCrypto);
    }

    public Crypto create(XKMSPortType xkmsClient, Crypto fallbackCrypto, boolean allowX509FromJKS) {
        return new XkmsCryptoProvider(xkmsClient, fallbackCrypto, allowX509FromJKS);
    }

    public Crypto create(String keystorePropsPath) {
        try {
            Properties keystoreProps = SecurityUtils.loadProperties((Object)keystorePropsPath);
            if (keystoreProps == null) {
                throw new CryptoProviderException("Cannot load security properties: " + keystorePropsPath);
            }
            Crypto defaultCrypto = CryptoFactory.getInstance((Properties)keystoreProps);
            return new XkmsCryptoProvider(this.xkmsConsumer, defaultCrypto);
        }
        catch (WSSecurityException e) {
            throw new CryptoProviderException("Cannot instantiate crypto factory: " + e.getMessage(), (Throwable)e);
        }
    }
}

