/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.service;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.exception.ExceptionMapper;
import org.apache.cxf.xkms.handlers.Locator;
import org.apache.cxf.xkms.handlers.Register;
import org.apache.cxf.xkms.handlers.Validator;
import org.apache.cxf.xkms.model.xkms.CompoundRequestType;
import org.apache.cxf.xkms.model.xkms.CompoundResultType;
import org.apache.cxf.xkms.model.xkms.KeyBindingAbstractType;
import org.apache.cxf.xkms.model.xkms.KeyBindingEnum;
import org.apache.cxf.xkms.model.xkms.KeyBindingType;
import org.apache.cxf.xkms.model.xkms.KeyUsageEnum;
import org.apache.cxf.xkms.model.xkms.LocateRequestType;
import org.apache.cxf.xkms.model.xkms.LocateResultType;
import org.apache.cxf.xkms.model.xkms.MessageAbstractType;
import org.apache.cxf.xkms.model.xkms.PendingRequestType;
import org.apache.cxf.xkms.model.xkms.RecoverRequestType;
import org.apache.cxf.xkms.model.xkms.RecoverResultType;
import org.apache.cxf.xkms.model.xkms.RegisterRequestType;
import org.apache.cxf.xkms.model.xkms.RegisterResultType;
import org.apache.cxf.xkms.model.xkms.ReissueRequestType;
import org.apache.cxf.xkms.model.xkms.ReissueResultType;
import org.apache.cxf.xkms.model.xkms.RequestAbstractType;
import org.apache.cxf.xkms.model.xkms.ResultMinorEnum;
import org.apache.cxf.xkms.model.xkms.ResultType;
import org.apache.cxf.xkms.model.xkms.RevokeRequestType;
import org.apache.cxf.xkms.model.xkms.RevokeResultType;
import org.apache.cxf.xkms.model.xkms.StatusRequestType;
import org.apache.cxf.xkms.model.xkms.StatusResultType;
import org.apache.cxf.xkms.model.xkms.StatusType;
import org.apache.cxf.xkms.model.xkms.UnverifiedKeyBindingType;
import org.apache.cxf.xkms.model.xkms.ValidateRequestType;
import org.apache.cxf.xkms.model.xkms.ValidateResultType;
import org.apache.cxf.xkms.service.XKMSResponseFactory;
import org.w3._2002._03.xkms_wsdl.XKMSPortType;

public class XKMSService
implements XKMSPortType {
    protected static final Logger LOG = LogUtils.getL7dLogger(XKMSService.class);
    private String serviceName = "http://cxf.apache.org/services/XKMS/";
    private List<Locator> locators = new ArrayList<Locator>();
    private List<Validator> validators = new ArrayList<Validator>();
    private List<Register> keyRegisterHandlers = new ArrayList<Register>();
    private boolean enableXKRSS = true;
    private boolean logExceptions;

    public ReissueResultType reissue(ReissueRequestType request) {
        ReissueResultType response = XKMSResponseFactory.createResponse((RequestAbstractType)request, new ReissueResultType());
        try {
            this.assertXKRSSAllowed();
            this.validateRequest((MessageAbstractType)request);
            for (Register handler : this.keyRegisterHandlers) {
                if (!handler.canProcess((RequestAbstractType)request)) continue;
                return handler.reissue(request, response);
            }
            throw new UnsupportedOperationException("Service was unable to handle your request");
        }
        catch (Exception e) {
            return this.handleException("reissue", e, response);
        }
    }

    public CompoundResultType compound(CompoundRequestType request) {
        this.validateRequest((MessageAbstractType)request);
        UnsupportedOperationException ex = new UnsupportedOperationException("XKMS compound request is currently not supported");
        CompoundResultType response = XKMSResponseFactory.createResponse((RequestAbstractType)request, new CompoundResultType());
        return this.handleException("compound", ex, response);
    }

    public RegisterResultType register(RegisterRequestType request) {
        RegisterResultType response = XKMSResponseFactory.createResponse((RequestAbstractType)request, new RegisterResultType());
        try {
            this.assertXKRSSAllowed();
            this.validateRequest((MessageAbstractType)request);
            for (Register handler : this.keyRegisterHandlers) {
                if (!handler.canProcess((RequestAbstractType)request)) continue;
                return handler.register(request, response);
            }
            throw new UnsupportedOperationException("Service was unable to handle your request");
        }
        catch (Exception e) {
            return this.handleException("register", e, response);
        }
    }

    public ResultType pending(PendingRequestType request) {
        this.validateRequest((MessageAbstractType)request);
        return ExceptionMapper.toResponse((Exception)new UnsupportedOperationException("XKMS request is currently not supported"), (ResultType)XKMSResponseFactory.createResponse((RequestAbstractType)request, new ResultType()));
    }

    public RevokeResultType revoke(RevokeRequestType request) {
        RevokeResultType response = XKMSResponseFactory.createResponse((RequestAbstractType)request, new RevokeResultType());
        try {
            this.assertXKRSSAllowed();
            this.validateRequest((MessageAbstractType)request);
            for (Register handler : this.keyRegisterHandlers) {
                if (!handler.canProcess((RequestAbstractType)request)) continue;
                return handler.revoke(request, response);
            }
            throw new UnsupportedOperationException("Service was unable to handle your request");
        }
        catch (Exception e) {
            return this.handleException("revoke", e, response);
        }
    }

    public LocateResultType locate(LocateRequestType request) {
        LocateResultType response = XKMSResponseFactory.createResponse((RequestAbstractType)request, new LocateResultType());
        try {
            this.validateRequest((MessageAbstractType)request);
            for (Locator locator : this.locators) {
                UnverifiedKeyBindingType keyBinding = locator.locate(request);
                if (keyBinding == null) continue;
                response.getUnverifiedKeyBinding().add(keyBinding);
                return response;
            }
            response.setResultMinor(ResultMinorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_NO_MATCH.value());
            return response;
        }
        catch (Exception e) {
            return this.handleException("locate", e, response);
        }
    }

    public RecoverResultType recover(RecoverRequestType request) {
        RecoverResultType response = XKMSResponseFactory.createResponse((RequestAbstractType)request, new RecoverResultType());
        try {
            this.assertXKRSSAllowed();
            this.validateRequest((MessageAbstractType)request);
            for (Register handler : this.keyRegisterHandlers) {
                if (!handler.canProcess((RequestAbstractType)request)) continue;
                return handler.recover(request, response);
            }
            throw new UnsupportedOperationException("Service was unable to handle your request");
        }
        catch (Exception e) {
            return this.handleException("recover", e, response);
        }
    }

    public StatusResultType status(StatusRequestType request) {
        this.validateRequest((MessageAbstractType)request);
        return (StatusResultType)ExceptionMapper.toResponse((Exception)new UnsupportedOperationException("XKMS request is currently not supported"), (ResultType)XKMSResponseFactory.createResponse((RequestAbstractType)request, new StatusResultType()));
    }

    public ValidateResultType validate(ValidateRequestType request) {
        ValidateResultType response = XKMSResponseFactory.createResponse((RequestAbstractType)request, new ValidateResultType());
        try {
            this.validateRequest((MessageAbstractType)request);
            KeyBindingType binding = XKMSService.createKeyBinding(response);
            for (Validator validator : this.validators) {
                StatusType status = validator.validate(request);
                this.addValidationReasons(binding, status);
            }
            this.resolveValidationStatus(binding);
            return response;
        }
        catch (Exception e) {
            return this.handleException("recover", e, response);
        }
    }

    private <T extends ResultType> T handleException(String method, Exception e, T response) {
        if (this.logExceptions) {
            LOG.log(Level.SEVERE, "Error during " + method + ": " + e.getMessage(), e);
        }
        return (T)ExceptionMapper.toResponse((Exception)e, response);
    }

    private void validateRequest(MessageAbstractType request) {
        if (request.getId() == null || request.getId().isEmpty()) {
            throw new IllegalArgumentException("Message Id is not set");
        }
        if (!this.serviceName.equals(request.getService())) {
            throw new IllegalArgumentException("Service " + request.getService() + " is not responsible to process request");
        }
    }

    public static KeyBindingType createKeyBinding(ValidateResultType result) {
        KeyBindingType binding = new KeyBindingType();
        binding.setId(XKMSResponseFactory.generateUniqueID());
        result.getKeyBinding().add(binding);
        StatusType status = new StatusType();
        binding.setStatus(status);
        return binding;
    }

    private void addValidationReasons(KeyBindingType binding, StatusType status) {
        StatusType resultStatus = binding.getStatus();
        resultStatus.getValidReason().addAll(status.getValidReason());
        resultStatus.getInvalidReason().addAll(status.getInvalidReason());
        resultStatus.getIndeterminateReason().addAll(status.getIndeterminateReason());
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setLocators(List<Locator> locators) {
        this.locators = locators;
    }

    public void setValidators(List<Validator> validators) {
        this.validators = validators;
    }

    public void setKeyRegisterHandlers(List<Register> keyRegisterHandlers) {
        this.keyRegisterHandlers = keyRegisterHandlers;
    }

    private void resolveValidationStatus(KeyBindingType binding) {
        StatusType status = binding.getStatus();
        status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_INDETERMINATE);
        if (!status.getValidReason().isEmpty() && status.getIndeterminateReason().isEmpty()) {
            status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_VALID);
        }
        if (!status.getInvalidReason().isEmpty()) {
            status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_INVALID);
            status.getValidReason().clear();
        }
    }

    protected void setKeyUsageAll(KeyBindingAbstractType keyBinding) {
        keyBinding.getKeyUsage().add(KeyUsageEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_ENCRYPTION);
        keyBinding.getKeyUsage().add(KeyUsageEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_SIGNATURE);
        keyBinding.getKeyUsage().add(KeyUsageEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_EXCHANGE);
    }

    public void setEnableXKRSS(boolean enableXKRSS) {
        this.enableXKRSS = enableXKRSS;
        LOG.info("enableXKRSS:" + enableXKRSS);
    }

    public void setLogExceptions(boolean logExceptions) {
        this.logExceptions = logExceptions;
    }

    private void assertXKRSSAllowed() {
        if (!this.enableXKRSS) {
            throw new UnsupportedOperationException("XKRSS Operations are disabled");
        }
    }
}

