/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.utils;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.model.xkms.LocateRequestType;
import org.apache.cxf.xkms.model.xkms.LocateResultType;
import org.apache.cxf.xkms.model.xkms.UnverifiedKeyBindingType;
import org.apache.cxf.xkms.model.xmldsig.KeyInfoType;
import org.apache.cxf.xkms.model.xmldsig.ObjectFactory;
import org.apache.cxf.xkms.model.xmldsig.X509DataType;

public final class X509Utils {
    public static final QName X509_DATA = new QName("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    public static final QName X509_KEY_NAME = new QName("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    public static final QName X509_ISSUER_SERIAL = new QName("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
    public static final QName X509_SUBJECT_NAME = new QName("http://www.w3.org/2000/09/xmldsig#", "X509SubjectName");
    public static final QName X509_CERTIFICATE = new QName("http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
    private static final Logger LOG = LogUtils.getL7dLogger(X509Utils.class);
    private static final CertificateFactory X509_FACTORY;

    private X509Utils() {
    }

    public static void parseX509Data(X509DataType x509Data, List<X509Certificate> certs) throws CertificateException {
        List dataList = x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName();
        for (Object x509Object : dataList) {
            JAXBElement x509Item;
            X509Certificate certificate;
            if (!(x509Object instanceof JAXBElement) || null == (certificate = X509Utils.parseX509Item(x509Item = (JAXBElement)x509Object))) continue;
            certs.add(certificate);
        }
    }

    private static X509Certificate parseX509Item(JAXBElement<?> x509Item) throws CertificateException {
        QName x509ItemName = x509Item.getName();
        if (X509_CERTIFICATE.equals(x509ItemName)) {
            X509Certificate certificate = X509Utils.extractCertificate(x509Item);
            LOG.fine("Extracted " + certificate.getSubjectX500Principal().getName());
            return certificate;
        }
        return null;
    }

    private static X509Certificate extractCertificate(JAXBElement<?> x509Item) throws CertificateException {
        JAXBElement<?> byteElement = x509Item;
        byte[] bytes = (byte[])byteElement.getValue();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        Certificate certificate = X509_FACTORY.generateCertificate(stream);
        if (certificate instanceof X509Certificate) {
            return (X509Certificate)certificate;
        }
        throw new CertificateException("Unsupported certificate type encountered: " + (certificate != null && certificate.getClass() != null ? certificate.getClass().getName() : "Null"));
    }

    public static UnverifiedKeyBindingType getUnverifiedKeyBinding(X509Certificate cert) throws CertificateEncodingException {
        UnverifiedKeyBindingType unverifiedKeyBinding = new UnverifiedKeyBindingType();
        unverifiedKeyBinding.setKeyInfo(X509Utils.getKeyInfo(cert));
        return unverifiedKeyBinding;
    }

    public static KeyInfoType getKeyInfo(X509Certificate cert) throws CertificateEncodingException {
        KeyInfoType keyInfo = new KeyInfoType();
        JAXBElement certificate = new ObjectFactory().createX509DataTypeX509Certificate(cert.getEncoded());
        X509DataType x509DataType = new X509DataType();
        List x509DataContent = x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName();
        x509DataContent.add(certificate);
        JAXBElement x509Data = new ObjectFactory().createX509Data(x509DataType);
        List keyInfoContent = keyInfo.getContent();
        keyInfoContent.add(x509Data);
        return keyInfo;
    }

    LocateResultType createResponse(LocateRequestType request) {
        LocateResultType ret = new LocateResultType();
        ret.setId(UUID.randomUUID().toString());
        ret.setRequestId(request.getId());
        ret.setService("http://services.sopera.org/xkms/v2.0");
        return ret;
    }

    public static void assertElementNotNull(Object element, Class<?> elementClass) {
        if (element == null) {
            throw new IllegalArgumentException(elementClass.getName() + " must be set");
        }
    }

    static {
        try {
            X509_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Cannot initialize X509 CertificateFactory: " + e.getMessage(), e);
        }
    }
}

