/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import java.net.URL;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.systest.http.BusServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world.Greeter;
import org.apache.hello_world.services.SOAPService;
import org.junit.Test;

public class CertConstraintsTest
extends AbstractBusClientServerTestBase {
    public static final String PORT0 = BusServer.PORT0;
    public static final String PORT1 = BusServer.PORT1;
    public static final String PORT2 = BusServer.PORT2;
    public static final String PORT3 = BusServer.PORT3;
    public static final String PORT4 = BusServer.PORT4;
    public static final String PORT5 = BusServer.PORT5;
    public static final String PORT6 = BusServer.PORT6;
    public static final String PORT7 = BusServer.PORT7;
    public static final String PORT8 = BusServer.PORT8;

    private void setTheConfiguration(String config) {
        try {
            System.setProperty("cxf.config.file.url", CertConstraintsTest.class.getResource(config).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startServers() throws Exception {
        CertConstraintsTest.assertTrue((String)"Server failed to launch", (boolean)CertConstraintsTest.launchServer(BusServer.class, (boolean)true));
    }

    public void stopServers() throws Exception {
        CertConstraintsTest.stopAllServers();
        System.clearProperty("cxf.config.file.url");
        BusFactory.setDefaultBus(null);
        BusFactory.setThreadDefaultBus(null);
    }

    public final void testSuccessfulCall(String address) throws Exception {
        URL url = SOAPService.WSDL_LOCATION;
        SOAPService service = new SOAPService(url, SOAPService.SERVICE);
        CertConstraintsTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter port = service.getHttpsPort();
        CertConstraintsTest.assertNotNull((String)"Port is null", (Object)port);
        BindingProvider provider = (BindingProvider)port;
        provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        CertConstraintsTest.assertEquals((Object)port.greetMe("Kitty"), (Object)"Hello Kitty");
    }

    public final void testFailedCall(String address) throws Exception {
        URL url = SOAPService.WSDL_LOCATION;
        SOAPService service = new SOAPService(url, SOAPService.SERVICE);
        CertConstraintsTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter port = service.getHttpsPort();
        CertConstraintsTest.assertNotNull((String)"Port is null", (Object)port);
        BindingProvider provider = (BindingProvider)port;
        provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        try {
            CertConstraintsTest.assertEquals((Object)port.greetMe("Kitty"), (Object)"Hello Kitty");
            CertConstraintsTest.fail((String)"Failure expected");
        }
        catch (SOAPFaultException ex) {
        }
        catch (WebServiceException ex) {
            // empty catch block
        }
    }

    @Test
    public final void testCertConstraints() throws Exception {
        this.setTheConfiguration("resources/jaxws-server-constraints.xml");
        this.startServers();
        this.testSuccessfulCall("https://localhost:" + PORT0 + "/SoapContext/HttpsPort");
        this.testFailedCall("https://localhost:" + PORT1 + "/SoapContext/HttpsPort");
        this.testFailedCall("https://localhost:" + PORT2 + "/SoapContext/HttpsPort");
        this.testSuccessfulCall("https://localhost:" + PORT3 + "/SoapContext/HttpsPort");
        this.testFailedCall("https://localhost:" + PORT4 + "/SoapContext/HttpsPort");
        this.testSuccessfulCall("https://localhost:" + PORT5 + "/SoapContext/HttpsPort");
        this.testFailedCall("https://localhost:" + PORT6 + "/SoapContext/HttpsPort");
        this.testFailedCall("https://localhost:" + PORT7 + "/SoapContext/HttpsPort");
        this.stopServers();
    }
}

