/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.systest.http.GreeterSessionImpl;
import org.apache.cxf.systest.http.SessionServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ClientServerSessionTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = SessionServer.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        ClientServerSessionTest.assertTrue((String)"server did not launch correctly", (boolean)ClientServerSessionTest.launchServer(SessionServer.class, (boolean)true));
    }

    @Test
    public void testInvocationWithSession() throws Exception {
        GreeterService service = new GreeterService();
        ClientServerSessionTest.assertNotNull((Object)service);
        try {
            Greeter greeter = service.getGreeterPort();
            BindingProvider bp = (BindingProvider)greeter;
            this.updateAddressPort(bp, PORT);
            bp.getRequestContext().put("javax.xml.ws.session.maintain", true);
            HashMap<String, List<String>> headers = CastUtils.cast((Map)((Map)bp.getRequestContext().get("javax.xml.ws.http.request.headers")));
            if (headers == null) {
                headers = new HashMap<String, List<String>>();
                bp.getRequestContext().put("javax.xml.ws.http.request.headers", headers);
            }
            List<String> cookies = Arrays.asList("a=a", "b=b");
            headers.put("Cookie", cookies);
            String greeting = greeter.greetMe("Bonjour");
            String cookie = "";
            if (greeting.indexOf(59) != -1) {
                cookie = greeting.substring(greeting.indexOf(59));
                greeting = greeting.substring(0, greeting.indexOf(59));
            }
            ClientServerSessionTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ClientServerSessionTest.assertEquals((Object)"Hello Bonjour", (Object)greeting);
            ClientServerSessionTest.assertTrue((boolean)cookie.contains("a=a"));
            ClientServerSessionTest.assertTrue((boolean)cookie.contains("b=b"));
            greeting = greeter.greetMe("Hello");
            cookie = "";
            if (greeting.indexOf(59) != -1) {
                cookie = greeting.substring(greeting.indexOf(59));
                greeting = greeting.substring(0, greeting.indexOf(59));
            }
            ClientServerSessionTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ClientServerSessionTest.assertEquals((Object)"Hello Bonjour", (Object)greeting);
            ClientServerSessionTest.assertTrue((boolean)cookie.contains("a=a"));
            ClientServerSessionTest.assertTrue((boolean)cookie.contains("b=b"));
            greeting = greeter.greetMe("NiHao");
            cookie = "";
            if (greeting.indexOf(59) != -1) {
                cookie = greeting.substring(greeting.indexOf(59));
                greeting = greeting.substring(0, greeting.indexOf(59));
            }
            ClientServerSessionTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ClientServerSessionTest.assertEquals((Object)"Hello Hello", (Object)greeting);
            ClientServerSessionTest.assertTrue((boolean)cookie.contains("a=a"));
            ClientServerSessionTest.assertTrue((boolean)cookie.contains("b=b"));
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    public void testInvocationWithoutSession() throws Exception {
        GreeterService service = new GreeterService();
        ClientServerSessionTest.assertNotNull((Object)service);
        try {
            Greeter greeter = service.getGreeterPort();
            this.updateAddressPort(greeter, PORT);
            String greeting = greeter.greetMe("Bonjour");
            ClientServerSessionTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ClientServerSessionTest.assertEquals((Object)"Hello Bonjour", (Object)greeting);
            greeting = greeter.greetMe("Hello");
            ClientServerSessionTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ClientServerSessionTest.assertEquals((Object)"Hello Hello", (Object)greeting);
            greeting = greeter.greetMe("NiHao");
            ClientServerSessionTest.assertNotNull((String)"no response received from service", (Object)greeting);
            ClientServerSessionTest.assertEquals((Object)"Hello NiHao", (Object)greeting);
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    @Test
    @Ignore(value="seem to get random failures on everything except Linux with this. Maybe a jetty issue.")
    public void testPublishOnBusyPort() {
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        GreeterSessionImpl implementor = new GreeterSessionImpl();
        String address = "http://localhost:" + PORT + "/SoapContext/GreeterPort";
        try {
            Endpoint.publish((String)address, (Object)implementor);
            if (!isWindows) {
                ClientServerSessionTest.fail((String)"Should have failed to publish as the port is busy");
            } else {
                System.err.println("Should have failed to publish as the port is busy, but certains of Windows allow this.");
            }
        }
        catch (WebServiceException ex) {
            // empty catch block
        }
        try {
            Endpoint.publish((String)address, (Object)implementor);
            if (!isWindows) {
                ClientServerSessionTest.fail((String)"Should have failed to publish as the port is busy");
            } else {
                System.err.println("Should have failed to publish as the port is busy, but certains of Windows allow this.");
            }
        }
        catch (WebServiceException ex) {
            // empty catch block
        }
    }

    @Test
    public void testInvocationWithSessionFactory() throws Exception {
        this.doSessionsTest("http://localhost:" + PORT + "/Stateful1");
    }

    @Test
    public void testInvocationWithSessionAnnotation() throws Exception {
        this.doSessionsTest("http://localhost:" + PORT + "/Stateful2");
    }

    @Test
    public void testInvocationWithPerRequestAnnotation() throws Exception {
        GreeterService service = new GreeterService();
        ClientServerSessionTest.assertNotNull((Object)service);
        Greeter greeter = service.getGreeterPort();
        BindingProvider bp = (BindingProvider)greeter;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:" + PORT + "/PerRequest");
        bp.getRequestContext().put("javax.xml.ws.session.maintain", true);
        String result = greeter.greetMe("World");
        ClientServerSessionTest.assertEquals((Object)"Hello World", (Object)result);
        ClientServerSessionTest.assertEquals((Object)"Bonjour default", (Object)greeter.sayHi());
    }

    @Test
    public void testInvocationWithSpringBeanAnnotation() throws Exception {
        GreeterService service = new GreeterService();
        ClientServerSessionTest.assertNotNull((Object)service);
        Greeter greeter = service.getGreeterPort();
        BindingProvider bp = (BindingProvider)greeter;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:" + PORT + "/SpringBean");
        bp.getRequestContext().put("javax.xml.ws.session.maintain", true);
        String result = greeter.greetMe("World");
        ClientServerSessionTest.assertEquals((Object)"Hello World", (Object)result);
        ClientServerSessionTest.assertEquals((Object)"Bonjour World", (Object)greeter.sayHi());
    }

    private void doSessionsTest(String url) {
        GreeterService service = new GreeterService();
        ClientServerSessionTest.assertNotNull((Object)service);
        Greeter greeter = service.getGreeterPort();
        Greeter greeter2 = service.getGreeterPort();
        BindingProvider bp = (BindingProvider)greeter;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        bp.getRequestContext().put("javax.xml.ws.session.maintain", true);
        bp = (BindingProvider)greeter2;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        bp.getRequestContext().put("javax.xml.ws.session.maintain", true);
        String result = greeter.greetMe("World");
        ClientServerSessionTest.assertEquals((Object)"Hello World", (Object)result);
        ClientServerSessionTest.assertEquals((Object)"Bonjour World", (Object)greeter.sayHi());
        result = greeter2.greetMe("Universe");
        ClientServerSessionTest.assertEquals((Object)"Hello Universe", (Object)result);
        ClientServerSessionTest.assertEquals((Object)"Bonjour Universe", (Object)greeter2.sayHi());
        ClientServerSessionTest.assertEquals((Object)"Bonjour World", (Object)greeter.sayHi());
    }
}

