/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import java.net.URL;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.systest.http.BusServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world.Greeter;
import org.apache.hello_world.services.SOAPService;
import org.junit.Test;

public class HTTPSClientTest
extends AbstractBusClientServerTestBase {
    public static final String PORT1 = BusServer.PORT1;
    public static final String PORT2 = BusServer.PORT2;
    public static final String PORT3 = BusServer.PORT3;
    public static final String PORT4 = BusServer.PORT4;
    public static final String PORT5 = BusServer.PORT5;
    public static final String PORT6 = BusServer.PORT6;

    private void setTheConfiguration(String config) {
        try {
            System.setProperty("cxf.config.file.url", HTTPSClientTest.class.getResource(config).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startServers() throws Exception {
        HTTPSClientTest.assertTrue((String)"Server failed to launch", (boolean)HTTPSClientTest.launchServer(BusServer.class, (boolean)true));
    }

    public void stopServers() throws Exception {
        HTTPSClientTest.stopAllServers();
        System.clearProperty("cxf.config.file.url");
        BusFactory.setDefaultBus(null);
        BusFactory.setThreadDefaultBus(null);
    }

    public final void testSuccessfulCall(String configuration, String address) throws Exception {
        this.testSuccessfulCall(configuration, address, null);
    }

    public final void testSuccessfulCall(String configuration, String address, URL url) throws Exception {
        this.testSuccessfulCall(configuration, address, url, false);
    }

    public final void testSuccessfulCall(String configuration, String address, URL url, boolean dynamicClient) throws Exception {
        this.setTheConfiguration(configuration);
        this.startServers();
        if (url == null) {
            url = SOAPService.WSDL_LOCATION;
        }
        if (dynamicClient) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            JaxWsDynamicClientFactory.newInstance((Bus)BusFactory.getDefaultBus()).createClient(url.toExternalForm());
            Thread.currentThread().setContextClassLoader(loader);
        }
        SOAPService service = new SOAPService(url, SOAPService.SERVICE);
        HTTPSClientTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter port = service.getHttpsPort();
        HTTPSClientTest.assertNotNull((String)"Port is null", (Object)port);
        BindingProvider provider = (BindingProvider)port;
        provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        HTTPSClientTest.assertEquals((Object)port.greetMe("Kitty"), (Object)"Hello Kitty");
        this.stopServers();
    }

    @Test
    public final void testJaxwsServer() throws Exception {
        this.testSuccessfulCall("resources/jaxws-server.xml", "https://localhost:" + PORT2 + "/SoapContext/HttpsPort");
    }

    @Test
    public final void testJaxwsServerChangeHttpsToHttp() throws Exception {
        this.testSuccessfulCall("resources/jaxws-server.xml", "http://localhost:" + PORT3 + "/SoapContext/HttpPort");
    }

    @Test
    public final void testJaxwsEndpoint() throws Exception {
        this.testSuccessfulCall("resources/jaxws-publish.xml", "https://localhost:" + PORT1 + "/SoapContext/HttpsPort");
    }

    @Test
    public final void testPKCS12Endpoint() throws Exception {
        this.testSuccessfulCall("resources/pkcs12.xml", "https://localhost:" + PORT6 + "/SoapContext/HttpsPort");
    }

    @Test
    public final void testResourceKeySpecEndpoint() throws Exception {
        this.testSuccessfulCall("resources/resource-key-spec.xml", "https://localhost:" + PORT4 + "/SoapContext/HttpsPort");
    }

    @Test
    public final void testResourceKeySpecEndpointURL() throws Exception {
        this.testSuccessfulCall("resources/resource-key-spec-url.xml", "https://localhost:" + PORT5 + "/SoapContext/HttpsPort", new URL("https://localhost:" + PORT5 + "/SoapContext/HttpsPort?wsdl"), true);
    }
}

