/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushBack401
extends AbstractPhaseInterceptor<Message> {
    PushBack401() {
        super("receive");
    }

    private String[] extractUserPass(String token) {
        try {
            byte[] userpass = Base64Utility.decode((String)token);
            String up = IOUtils.newStringFromBytes((byte[])userpass);
            String user = up.substring(0, up.indexOf(58));
            String pass = up.substring(up.indexOf(58) + 1);
            return new String[]{user, pass};
        }
        catch (Exception e) {
            return null;
        }
    }

    private String checkUserPass(String user, String pass) throws Exception {
        if (!"password".equals(pass)) {
            throw new Exception("bad password");
        }
        if ("Mary".equals(user)) {
            return "Andromeda";
        }
        if ("Edward".equals(user)) {
            return "Zorantius";
        }
        if ("George".equals(user)) {
            return "Cronus";
        }
        return null;
    }

    public void handleMessage(Message message) throws Fault {
        Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        List auth = (List)headers.get("Authorization");
        if (auth == null) {
            this.replyUnauthorized(message, "Cronus");
            return;
        }
        for (String a : auth) {
            String[] userpass;
            if (!a.startsWith("Basic ") || (userpass = this.extractUserPass(a.substring("Basic ".length()))) == null) continue;
            try {
                String realm = this.checkUserPass(userpass[0], userpass[1]);
                if (realm != null) {
                    this.replyUnauthorized(message, realm);
                    return;
                }
                return;
            }
            catch (Exception e) {
                this.replyUnauthorized(message, null);
                return;
            }
        }
        this.replyUnauthorized(message, null);
    }

    private void replyUnauthorized(Message message, String realm) {
        Message outMessage = this.getOutMessage(message);
        outMessage.put((Object)Message.RESPONSE_CODE, (Object)401);
        if (realm != null) {
            this.setHeader(outMessage, "WWW-Authenticate", "Basic realm=" + realm);
        }
        message.getInterceptorChain().abort();
        try {
            this.getConduit(message).prepare(outMessage);
            this.close(outMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Message getOutMessage(Message message) {
        Exchange exchange = message.getExchange();
        Message outMessage = exchange.getOutMessage();
        if (outMessage == null) {
            Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
            outMessage = new MessageImpl();
            outMessage.setExchange(exchange);
            outMessage = endpoint.getBinding().createMessage(outMessage);
            exchange.setOutMessage(outMessage);
        }
        outMessage.putAll((Map)message);
        return outMessage;
    }

    private void setHeader(Message message, String key, String value) {
        Map responseHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (responseHeaders != null) {
            responseHeaders.put(key, Arrays.asList(value));
        }
    }

    private Conduit getConduit(Message message) throws IOException {
        Exchange exchange = message.getExchange();
        EndpointReferenceType target = (EndpointReferenceType)exchange.get(EndpointReferenceType.class);
        Conduit conduit = exchange.getDestination().getBackChannel(message, null, target);
        exchange.setConduit(conduit);
        return conduit;
    }

    private void close(Message message) throws IOException {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        os.flush();
        os.close();
    }
}

