/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import javax.xml.ws.Endpoint;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.systest.http.GreeterImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Before;
import org.junit.Test;

public class WSDLAddressRewriteTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = WSDLAddressRewriteTest.allocatePort(WSDLAddressRewriteTest.class);

    @Before
    public void setupBus() throws Exception {
        WSDLAddressRewriteTest.createStaticBus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithSameAddress() throws Exception {
        String soapAddressLine;
        Endpoint endpoint = null;
        try {
            endpoint = this.publishEndpoint(false);
            soapAddressLine = this.getSoapAddressLine("localhost");
            WSDLAddressRewriteTest.assertTrue((boolean)soapAddressLine.contains("address location=\"http://localhost"));
        }
        finally {
            if (endpoint != null) {
                endpoint.stop();
            }
        }
        try {
            endpoint = this.publishEndpoint(true);
            soapAddressLine = this.getSoapAddressLine("localhost");
            WSDLAddressRewriteTest.assertTrue((boolean)soapAddressLine.contains("address location=\"http://localhost"));
        }
        finally {
            if (endpoint != null) {
                endpoint.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithEquivalentAddress() throws Exception {
        String soapAddressLine;
        Endpoint endpoint = null;
        try {
            endpoint = this.publishEndpoint(false);
            soapAddressLine = this.getSoapAddressLine("127.0.0.1");
            WSDLAddressRewriteTest.assertTrue((boolean)soapAddressLine.contains("address location=\"http://localhost"));
        }
        finally {
            if (endpoint != null) {
                endpoint.stop();
            }
        }
        try {
            endpoint = this.publishEndpoint(true);
            soapAddressLine = this.getSoapAddressLine("127.0.0.1");
            WSDLAddressRewriteTest.assertTrue((boolean)soapAddressLine.contains("address location=\"http://127.0.0.1"));
        }
        finally {
            if (endpoint != null) {
                endpoint.stop();
            }
        }
    }

    private String getSoapAddressLine(String address) throws Exception {
        String line;
        Socket s = new Socket(address, Integer.parseInt(PORT));
        OutputStream os = s.getOutputStream();
        os.write("GET /SoapContext/GreeterPort?wsdl HTTP/1.1\r\n".getBytes());
        os.write(("Host:" + address + "\r\n\r\n").getBytes());
        os.flush();
        InputStream is = s.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while (!(line = reader.readLine()).contains("address location=\"")) {
        }
        is.close();
        os.close();
        s.close();
        return line;
    }

    private Endpoint publishEndpoint(boolean autoRewriteSoapAddress) {
        Endpoint endpoint = Endpoint.publish((String)("http://localhost:" + PORT + "/SoapContext/GreeterPort"), (Object)new GreeterImpl());
        EndpointInfo ei = ((EndpointImpl)endpoint).getServer().getEndpoint().getEndpointInfo();
        ei.setProperty("autoRewriteSoapAddress", (Object)autoRewriteSoapAddress);
        return endpoint;
    }
}

