/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.cxf.systest.http.BareServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSDLQueryTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = BareServer.PORT;

    @BeforeClass
    public static void startServers() throws Exception {
        WSDLQueryTest.assertTrue((String)"server did not launch correctly", (boolean)WSDLQueryTest.launchServer(BareServer.class, (boolean)true));
    }

    @Test
    public void testEmptyHostHeader() throws Exception {
        this.sendQuery("", "HTTP/1.1 200 OK");
    }

    @Test
    public void testCorrectHostHeader() throws Exception {
        this.sendQuery("localhost:" + PORT, "HTTP/1.1 200 OK");
    }

    @Test
    public void testCorrectHostNoPortHeader() throws Exception {
        this.sendQuery("localhost", "HTTP/1.1 200 OK");
    }

    @Test
    public void testBogusHostHeader() throws Exception {
        this.sendQuery("foobar:" + PORT, "HTTP/1.1 200 OK");
    }

    @Test
    public void testBogusHostBogusPortHeader() throws Exception {
        this.sendQuery("foobar:666", "HTTP/1.1 200 OK");
    }

    @Test
    public void testWithBogusHostNoPortHeader() throws Exception {
        this.sendQuery("foobar", "HTTP/1.1 200 OK");
    }

    private void sendQuery(String hostHeader, String expectedResponseLine) throws Exception {
        Socket s = new Socket("localhost", Integer.parseInt(PORT));
        OutputStream os = s.getOutputStream();
        os.write("GET /SoapContext/GreeterPort?wsdl HTTP/1.1\r\n".getBytes());
        os.write(("Host:" + hostHeader + "\r\n\r\n").getBytes());
        os.flush();
        InputStream is = s.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        WSDLQueryTest.assertEquals((String)"unexpected response", (Object)expectedResponseLine, (Object)line);
        is.close();
        os.close();
        s.close();
    }
}

