/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.http.auth;

import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.http.auth.DigestServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.hello_world.Greeter;
import org.apache.hello_world.services.SOAPService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DigestAuthTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = DigestAuthTest.allocatePort(DigestServer.class);
    private final QName serviceName = new QName("http://apache.org/hello_world", "SOAPService");
    private final QName mortimerQ = new QName("http://apache.org/hello_world", "Mortimer");

    @BeforeClass
    public static void startServer() {
        DigestAuthTest.launchServer(DigestServer.class, (boolean)true);
    }

    @Test
    public void testDigestAuth() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("../resources/greeting.wsdl");
        DigestAuthTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DigestAuthTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter mortimer = (Greeter)service.getPort(this.mortimerQ, Greeter.class);
        DigestAuthTest.assertNotNull((String)"Port is null", (Object)mortimer);
        this.setAddress(mortimer, "http://localhost:" + PORT + "/digestauth/greeter");
        Client client = ClientProxy.getClient((Object)mortimer);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        AuthorizationPolicy authPolicy = new AuthorizationPolicy();
        authPolicy.setAuthorizationType("Digest");
        authPolicy.setUserName("foo");
        authPolicy.setPassword("bar");
        http.setAuthorization(authPolicy);
        String answer = mortimer.sayHi();
        DigestAuthTest.assertEquals((String)("Unexpected answer: " + answer), (Object)"Hi", (Object)answer);
    }

    @Test
    public void testNoAuth() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("../resources/greeting.wsdl");
        DigestAuthTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        SOAPService service = new SOAPService(wsdl, this.serviceName);
        DigestAuthTest.assertNotNull((String)"Service is null", (Object)service);
        Greeter mortimer = (Greeter)service.getPort(this.mortimerQ, Greeter.class);
        DigestAuthTest.assertNotNull((String)"Port is null", (Object)mortimer);
        this.setAddress(mortimer, "http://localhost:" + PORT + "/digestauth/greeter");
        try {
            String answer = mortimer.sayHi();
            Assert.fail((String)("Unexpected reply (" + answer + "). Should throw exception"));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(HTTPException.class, cause.getClass());
            HTTPException he = (HTTPException)cause;
            Assert.assertEquals((long)401L, (long)he.getResponseCode());
        }
    }
}

